unit DirectPlayFPC;

{$I SWITCHES.INC}

interface

uses
	windows, DirectDraw, DirectPlay, ole2;


// IDirectPlay2AW interface methods

function IDirectPlay2_AddRef(idd : IDirectPlay2AW) : Longint; stdcall;
function IDirectPlay2_Release(idd : IDirectPlay2AW) : Longint; stdcall;
function IDirectPlay2_AddPlayerToGroup(idd : IDirectPlay2AW; idGroup : TDPID; idPlayer : TDPID) : HResult; stdcall;
function IDirectPlay2_Close(idd : IDirectPlay2AW) : HResult; stdcall;
function IDirectPlay2_CreateGroup(idd : IDirectPlay2AW; var lpidGroup : TDPID; lpGroupName : PDPName; lpData : Pointer; dwDataSize : DWORD; dwFlags : DWORD) : HResult; stdcall;
function IDirectPlay2_CreatePlayer(idd : IDirectPlay2AW; var lpidPlayer : TDPID; pPlayerName : PDPName; hEvent : THandle; lpData : Pointer; dwDataSize : DWORD; dwFlags : DWORD) : HResult; stdcall;
function IDirectPlay2_DeletePlayerFromGroup(idd : IDirectPlay2AW; idGroup : TDPID; idPlayer : TDPID) : HResult; stdcall;
function IDirectPlay2_DestroyGroup(idd : IDirectPlay2AW; idGroup : TDPID) : HResult; stdcall;
function IDirectPlay2_DestroyPlayer(idd : IDirectPlay2AW; idPlayer : TDPID) : HResult; stdcall;
function IDirectPlay2_EnumGroupPlayers(idd : IDirectPlay2AW; idGroup : TDPID; lpguidInstance : PGUID; lpEnumPlayersCallback2 : TDPEnumPlayersCallback2; lpContext : Pointer; dwFlags : DWORD) : HResult; stdcall;
function IDirectPlay2_EnumGroups(idd : IDirectPlay2AW; lpguidInstance : PGUID; lpEnumPlayersCallback2 : TDPEnumPlayersCallback2; lpContext : Pointer; dwFlags : DWORD) : HResult; stdcall;
function IDirectPlay2_EnumPlayers(idd : IDirectPlay2AW; lpguidInstance : PGUID; lpEnumPlayersCallback2 : TDPEnumPlayersCallback2; lpContext : Pointer; dwFlags : DWORD) : HResult; stdcall;
function IDirectPlay2_EnumSessions(idd : IDirectPlay2AW; const lpsd : TDPSessionDesc2; dwTimeout : DWORD; lpEnumSessionsCallback2 : TDPEnumSessionsCallback2; lpContext : Pointer; dwFlags : DWORD) : HResult; stdcall;
function IDirectPlay2_GetCaps(idd : IDirectPlay2AW; var lpDPCaps : TDPCaps; dwFlags : DWORD) : HResult; stdcall;
function IDirectPlay2_GetGroupData(idd : IDirectPlay2AW; idGroup : TDPID; lpData : Pointer; var lpdwDataSize : DWORD; dwFlags : DWORD) : HResult; stdcall;
function IDirectPlay2_GetGroupName(idd : IDirectPlay2AW; idGroup : TDPID; lpData : Pointer; var lpdwDataSize : DWORD) : HResult; stdcall;
function IDirectPlay2_GetMessageCount(idd : IDirectPlay2AW; idPlayer : TDPID; var lpdwCount : DWORD) : HResult; stdcall;
function IDirectPlay2_GetPlayerAddress(idd : IDirectPlay2AW; idPlayer : TDPID; lpAddress : Pointer; var lpdwAddressSize : DWORD) : HResult; stdcall;
function IDirectPlay2_GetPlayerCaps(idd : IDirectPlay2AW; idPlayer : TDPID; var lpPlayerCaps : TDPCaps; dwFlags : DWORD) : HResult; stdcall;
function IDirectPlay2_GetPlayerData(idd : IDirectPlay2AW; idPlayer : TDPID; lpData : Pointer; var lpdwDataSize : DWORD; dwFlags : DWORD) : HResult; stdcall;
function IDirectPlay2_GetPlayerName(idd : IDirectPlay2AW; idPlayer : TDPID; lpData : Pointer; var lpdwDataSize : DWORD) : HResult; stdcall;
function IDirectPlay2_GetSessionDesc(idd : IDirectPlay2AW; lpData : Pointer; var lpdwDataSize : DWORD) : HResult; stdcall;
function IDirectPlay2_Initialize(idd : IDirectPlay2AW; const lpGUID : TGUID) : HResult; stdcall;
function IDirectPlay2_Open(idd : IDirectPlay2AW; var lpsd : TDPSessionDesc2; dwFlags : DWORD) : HResult; stdcall;
function IDirectPlay2_Receive(idd : IDirectPlay2AW; var lpidFrom : TDPID; var lpidTo : TDPID; dwFlags : DWORD; lpData : Pointer; var lpdwDataSize : DWORD) : HResult; stdcall;
function IDirectPlay2_Send(idd : IDirectPlay2AW; idFrom : TDPID; lpidTo : TDPID; dwFlags : DWORD; var lpData; lpdwDataSize : DWORD) : HResult; stdcall;
function IDirectPlay2_SetGroupData(idd : IDirectPlay2AW; idGroup : TDPID; lpData : Pointer; dwDataSize : DWORD; dwFlags : DWORD) : HResult; stdcall;
function IDirectPlay2_SetGroupName(idd : IDirectPlay2AW; idGroup : TDPID; lpGroupName : PDPName; dwFlags : DWORD) : HResult; stdcall;
function IDirectPlay2_SetPlayerData(idd : IDirectPlay2AW; idPlayer : TDPID; lpData : Pointer; dwDataSize : DWORD; dwFlags : DWORD) : HResult; stdcall;
function IDirectPlay2_SetPlayerName(idd : IDirectPlay2AW; idPlayer : TDPID; lpPlayerName : PDPName; dwFlags : DWORD) : HResult; stdcall;
function IDirectPlay2_SetSessionDesc(idd : IDirectPlay2AW; var lpSessDesc : TDPSessionDesc2; dwFlags : DWORD) : HResult; stdcall;


// IDirectPlay3AW interface methods

function IDirectPlay3_AddRef(idd : IDirectPlay3AW) : Longint; stdcall;
function IDirectPlay3_Release(idd : IDirectPlay3AW) : Longint; stdcall;
function IDirectPlay3_AddPlayerToGroup(idd : IDirectPlay3AW; idGroup : TDPID; idPlayer : TDPID) : HResult; stdcall;
function IDirectPlay3_Close(idd : IDirectPlay3AW) : HResult; stdcall;
function IDirectPlay3_CreateGroup(idd : IDirectPlay3AW; var lpidGroup : TDPID; lpGroupName : PDPName; lpData : Pointer; dwDataSize : DWORD; dwFlags : DWORD) : HResult; stdcall;
function IDirectPlay3_CreatePlayer(idd : IDirectPlay3AW; var lpidPlayer : TDPID; pPlayerName : PDPName; hEvent : THandle; lpData : Pointer; dwDataSize : DWORD; dwFlags : DWORD) : HResult; stdcall;
function IDirectPlay3_DeletePlayerFromGroup(idd : IDirectPlay3AW; idGroup : TDPID; idPlayer : TDPID) : HResult; stdcall;
function IDirectPlay3_DestroyGroup(idd : IDirectPlay3AW; idGroup : TDPID) : HResult; stdcall;
function IDirectPlay3_DestroyPlayer(idd : IDirectPlay3AW; idPlayer : TDPID) : HResult; stdcall;
function IDirectPlay3_EnumGroupPlayers(idd : IDirectPlay3AW; idGroup : TDPID; lpguidInstance : PGUID; lpEnumPlayersCallback2 : TDPEnumPlayersCallback2; lpContext : Pointer; dwFlags : DWORD) : HResult; stdcall;
function IDirectPlay3_EnumGroups(idd : IDirectPlay3AW; lpguidInstance : PGUID; lpEnumPlayersCallback2 : TDPEnumPlayersCallback2; lpContext : Pointer; dwFlags : DWORD) : HResult; stdcall;
function IDirectPlay3_EnumPlayers(idd : IDirectPlay3AW; lpguidInstance : PGUID; lpEnumPlayersCallback2 : TDPEnumPlayersCallback2; lpContext : Pointer; dwFlags : DWORD) : HResult; stdcall;
function IDirectPlay3_EnumSessions(idd : IDirectPlay3AW; const lpsd : TDPSessionDesc2; dwTimeout : DWORD; lpEnumSessionsCallback2 : TDPEnumSessionsCallback2; lpContext : Pointer; dwFlags : DWORD) : HResult; stdcall;
function IDirectPlay3_GetCaps(idd : IDirectPlay3AW; var lpDPCaps : TDPCaps; dwFlags : DWORD) : HResult; stdcall;
function IDirectPlay3_GetGroupData(idd : IDirectPlay3AW; idGroup : TDPID; lpData : Pointer; var lpdwDataSize : DWORD; dwFlags : DWORD) : HResult; stdcall;
function IDirectPlay3_GetGroupName(idd : IDirectPlay3AW; idGroup : TDPID; lpData : Pointer; var lpdwDataSize : DWORD) : HResult; stdcall;
function IDirectPlay3_GetMessageCount(idd : IDirectPlay3AW; idPlayer : TDPID; var lpdwCount : DWORD) : HResult; stdcall;
function IDirectPlay3_GetPlayerAddress(idd : IDirectPlay3AW; idPlayer : TDPID; lpAddress : Pointer; var lpdwAddressSize : DWORD) : HResult; stdcall;
function IDirectPlay3_GetPlayerCaps(idd : IDirectPlay3AW; idPlayer : TDPID; var lpPlayerCaps : TDPCaps; dwFlags : DWORD) : HResult; stdcall;
function IDirectPlay3_GetPlayerData(idd : IDirectPlay3AW; idPlayer : TDPID; lpData : Pointer; var lpdwDataSize : DWORD; dwFlags : DWORD) : HResult; stdcall;
function IDirectPlay3_GetPlayerName(idd : IDirectPlay3AW; idPlayer : TDPID; lpData : Pointer; var lpdwDataSize : DWORD) : HResult; stdcall;
function IDirectPlay3_GetSessionDesc(idd : IDirectPlay3AW; lpData : Pointer; var lpdwDataSize : DWORD) : HResult; stdcall;
function IDirectPlay3_Initialize(idd : IDirectPlay3AW; const lpGUID : TGUID) : HResult; stdcall;
function IDirectPlay3_Open(idd : IDirectPlay3AW; var lpsd : TDPSessionDesc2; dwFlags : DWORD) : HResult; stdcall;
function IDirectPlay3_Receive(idd : IDirectPlay3AW; var lpidFrom : TDPID; var lpidTo : TDPID; dwFlags : DWORD; lpData : Pointer; var lpdwDataSize : DWORD) : HResult; stdcall;
function IDirectPlay3_Send(idd : IDirectPlay3AW; idFrom : TDPID; lpidTo : TDPID; dwFlags : DWORD; var lpData; lpdwDataSize : DWORD) : HResult; stdcall;
function IDirectPlay3_SetGroupData(idd : IDirectPlay3AW; idGroup : TDPID; lpData : Pointer; dwDataSize : DWORD; dwFlags : DWORD) : HResult; stdcall;
function IDirectPlay3_SetGroupName(idd : IDirectPlay3AW; idGroup : TDPID; lpGroupName : PDPName; dwFlags : DWORD) : HResult; stdcall;
function IDirectPlay3_SetPlayerData(idd : IDirectPlay3AW; idPlayer : TDPID; lpData : Pointer; dwDataSize : DWORD; dwFlags : DWORD) : HResult; stdcall;
function IDirectPlay3_SetPlayerName(idd : IDirectPlay3AW; idPlayer : TDPID; lpPlayerName : PDPName; dwFlags : DWORD) : HResult; stdcall;
function IDirectPlay3_SetSessionDesc(idd : IDirectPlay3AW; var lpSessDesc : TDPSessionDesc2; dwFlags : DWORD) : HResult; stdcall;
function IDirectPlay3_AddGroupToGroup(idd : IDirectPlay3AW; idParentGroup : TDPID; idGroup : TDPID) : HResult; stdcall;
function IDirectPlay3_CreateGroupInGroup(idd : IDirectPlay3AW; idParentGroup : TDPID; var lpidGroup : TDPID; lpGroupName : PDPName; lpData : Pointer; dwDataSize : DWORD; dwFlags : DWORD) : HResult; stdcall;
function IDirectPlay3_DeleteGroupFromGroup(idd : IDirectPlay3AW; idParentGroup : TDPID; idGroup : TDPID) : HResult; stdcall;
function IDirectPlay3_EnumConnections(idd : IDirectPlay3AW; lpguidApplication : PGUID; lpEnumCallback : TDPEnumConnectionsCallback; lpContext : Pointer; dwFlags : DWORD) : HResult; stdcall;
function IDirectPlay3_EnumGroupsInGroup(idd : IDirectPlay3AW; idGroup : TDPID; lpguidInstance : PGUID; lpEnumPlayersCallback2 : TDPEnumPlayersCallback2; lpContext : Pointer; dwFlags : DWORD) : HResult; stdcall;
function IDirectPlay3_GetGroupConnectionSettings(idd : IDirectPlay3AW; dwFlags : DWORD; idGroup : TDPID; lpData : Pointer; var lpdwDataSize : DWORD) : HResult; stdcall;
function IDirectPlay3_InitializeConnection(idd : IDirectPlay3AW; lpConnection : Pointer; dwFlags : DWORD) : HResult; stdcall;
function IDirectPlay3_SecureOpen(idd : IDirectPlay3AW; var lpsd : TDPSessionDesc2; dwFlags : DWORD; var lpSecurity : TDPSecurityDesc; var lpCredentials : TDPCredentials) : HResult; stdcall;
function IDirectPlay3_SendChatMessage(idd : IDirectPlay3AW; idFrom : TDPID; idTo : TDPID; dwFlags : DWORD; var lpChatMessage : TDPChat) : HResult; stdcall;
function IDirectPlay3_SetGroupConnectionSettings(idd : IDirectPlay3AW; dwFlags : DWORD; idGroup : TDPID; var lpConnection : TDPLConnection) : HResult; stdcall;
function IDirectPlay3_StartSession(idd : IDirectPlay3AW; dwFlags : DWORD; idGroup : TDPID) : HResult; stdcall;
function IDirectPlay3_GetGroupFlags(idd : IDirectPlay3AW; idGroup : TDPID; var lpdwFlags : DWORD) : HResult; stdcall;
function IDirectPlay3_GetGroupParent(idd : IDirectPlay3AW; idGroup : TDPID; var lpidParent : TDPID) : HResult; stdcall;
function IDirectPlay3_GetPlayerAccount(idd : IDirectPlay3AW; idPlayer : TDPID; dwFlags : DWORD; var lpData; var lpdwDataSize : DWORD) : HResult; stdcall;
function IDirectPlay3_GetPlayerFlags(idd : IDirectPlay3AW; idPlayer : TDPID; var lpdwFlags : DWORD) : HResult; stdcall;

// IDirectPlay3W interface methods


// IDirectPlay3A interface methods


// IDirectPlay4AW interface methods

function IDirectPlay4_AddRef(idd : IDirectPlay4AW) : Longint; stdcall;
function IDirectPlay4_Release(idd : IDirectPlay4AW) : Longint; stdcall;
function IDirectPlay4_AddPlayerToGroup(idd : IDirectPlay4AW; idGroup : TDPID; idPlayer : TDPID) : HResult; stdcall;
function IDirectPlay4_Close(idd : IDirectPlay4AW) : HResult; stdcall;
function IDirectPlay4_CreateGroup(idd : IDirectPlay4AW; var lpidGroup : TDPID; lpGroupName : PDPName; lpData : Pointer; dwDataSize : DWORD; dwFlags : DWORD) : HResult; stdcall;
function IDirectPlay4_CreatePlayer(idd : IDirectPlay4AW; var lpidPlayer : TDPID; pPlayerName : PDPName; hEvent : THandle; lpData : Pointer; dwDataSize : DWORD; dwFlags : DWORD) : HResult; stdcall;
function IDirectPlay4_DeletePlayerFromGroup(idd : IDirectPlay4AW; idGroup : TDPID; idPlayer : TDPID) : HResult; stdcall;
function IDirectPlay4_DestroyGroup(idd : IDirectPlay4AW; idGroup : TDPID) : HResult; stdcall;
function IDirectPlay4_DestroyPlayer(idd : IDirectPlay4AW; idPlayer : TDPID) : HResult; stdcall;
function IDirectPlay4_EnumGroupPlayers(idd : IDirectPlay4AW; idGroup : TDPID; lpguidInstance : PGUID; lpEnumPlayersCallback2 : TDPEnumPlayersCallback2; lpContext : Pointer; dwFlags : DWORD) : HResult; stdcall;
function IDirectPlay4_EnumGroups(idd : IDirectPlay4AW; lpguidInstance : PGUID; lpEnumPlayersCallback2 : TDPEnumPlayersCallback2; lpContext : Pointer; dwFlags : DWORD) : HResult; stdcall;
function IDirectPlay4_EnumPlayers(idd : IDirectPlay4AW; lpguidInstance : PGUID; lpEnumPlayersCallback2 : TDPEnumPlayersCallback2; lpContext : Pointer; dwFlags : DWORD) : HResult; stdcall;
function IDirectPlay4_EnumSessions(idd : IDirectPlay4AW; const lpsd : TDPSessionDesc2; dwTimeout : DWORD; lpEnumSessionsCallback2 : TDPEnumSessionsCallback2; lpContext : Pointer; dwFlags : DWORD) : HResult; stdcall;
function IDirectPlay4_GetCaps(idd : IDirectPlay4AW; var lpDPCaps : TDPCaps; dwFlags : DWORD) : HResult; stdcall;
function IDirectPlay4_GetGroupData(idd : IDirectPlay4AW; idGroup : TDPID; lpData : Pointer; var lpdwDataSize : DWORD; dwFlags : DWORD) : HResult; stdcall;
function IDirectPlay4_GetGroupName(idd : IDirectPlay4AW; idGroup : TDPID; lpData : Pointer; var lpdwDataSize : DWORD) : HResult; stdcall;
function IDirectPlay4_GetMessageCount(idd : IDirectPlay4AW; idPlayer : TDPID; var lpdwCount : DWORD) : HResult; stdcall;
function IDirectPlay4_GetPlayerAddress(idd : IDirectPlay4AW; idPlayer : TDPID; lpAddress : Pointer; var lpdwAddressSize : DWORD) : HResult; stdcall;
function IDirectPlay4_GetPlayerCaps(idd : IDirectPlay4AW; idPlayer : TDPID; var lpPlayerCaps : TDPCaps; dwFlags : DWORD) : HResult; stdcall;
function IDirectPlay4_GetPlayerData(idd : IDirectPlay4AW; idPlayer : TDPID; lpData : Pointer; var lpdwDataSize : DWORD; dwFlags : DWORD) : HResult; stdcall;
function IDirectPlay4_GetPlayerName(idd : IDirectPlay4AW; idPlayer : TDPID; lpData : Pointer; var lpdwDataSize : DWORD) : HResult; stdcall;
function IDirectPlay4_GetSessionDesc(idd : IDirectPlay4AW; lpData : Pointer; var lpdwDataSize : DWORD) : HResult; stdcall;
function IDirectPlay4_Initialize(idd : IDirectPlay4AW; const lpGUID : TGUID) : HResult; stdcall;
function IDirectPlay4_Open(idd : IDirectPlay4AW; var lpsd : TDPSessionDesc2; dwFlags : DWORD) : HResult; stdcall;
function IDirectPlay4_Receive(idd : IDirectPlay4AW; var lpidFrom : TDPID; var lpidTo : TDPID; dwFlags : DWORD; lpData : Pointer; var lpdwDataSize : DWORD) : HResult; stdcall;
function IDirectPlay4_Send(idd : IDirectPlay4AW; idFrom : TDPID; lpidTo : TDPID; dwFlags : DWORD; var lpData; lpdwDataSize : DWORD) : HResult; stdcall;
function IDirectPlay4_SetGroupData(idd : IDirectPlay4AW; idGroup : TDPID; lpData : Pointer; dwDataSize : DWORD; dwFlags : DWORD) : HResult; stdcall;
function IDirectPlay4_SetGroupName(idd : IDirectPlay4AW; idGroup : TDPID; lpGroupName : PDPName; dwFlags : DWORD) : HResult; stdcall;
function IDirectPlay4_SetPlayerData(idd : IDirectPlay4AW; idPlayer : TDPID; lpData : Pointer; dwDataSize : DWORD; dwFlags : DWORD) : HResult; stdcall;
function IDirectPlay4_SetPlayerName(idd : IDirectPlay4AW; idPlayer : TDPID; lpPlayerName : PDPName; dwFlags : DWORD) : HResult; stdcall;
function IDirectPlay4_SetSessionDesc(idd : IDirectPlay4AW; var lpSessDesc : TDPSessionDesc2; dwFlags : DWORD) : HResult; stdcall;
function IDirectPlay4_AddGroupToGroup(idd : IDirectPlay4AW; idParentGroup : TDPID; idGroup : TDPID) : HResult; stdcall;
function IDirectPlay4_CreateGroupInGroup(idd : IDirectPlay4AW; idParentGroup : TDPID; var lpidGroup : TDPID; lpGroupName : PDPName; lpData : Pointer; dwDataSize : DWORD; dwFlags : DWORD) : HResult; stdcall;
function IDirectPlay4_DeleteGroupFromGroup(idd : IDirectPlay4AW; idParentGroup : TDPID; idGroup : TDPID) : HResult; stdcall;
function IDirectPlay4_EnumConnections(idd : IDirectPlay4AW; lpguidApplication : PGUID; lpEnumCallback : TDPEnumConnectionsCallback; lpContext : Pointer; dwFlags : DWORD) : HResult; stdcall;
function IDirectPlay4_EnumGroupsInGroup(idd : IDirectPlay4AW; idGroup : TDPID; lpguidInstance : PGUID; lpEnumPlayersCallback2 : TDPEnumPlayersCallback2; lpContext : Pointer; dwFlags : DWORD) : HResult; stdcall;
function IDirectPlay4_GetGroupConnectionSettings(idd : IDirectPlay4AW; dwFlags : DWORD; idGroup : TDPID; lpData : Pointer; var lpdwDataSize : DWORD) : HResult; stdcall;
function IDirectPlay4_InitializeConnection(idd : IDirectPlay4AW; lpConnection : Pointer; dwFlags : DWORD) : HResult; stdcall;
function IDirectPlay4_SecureOpen(idd : IDirectPlay4AW; var lpsd : TDPSessionDesc2; dwFlags : DWORD; var lpSecurity : TDPSecurityDesc; var lpCredentials : TDPCredentials) : HResult; stdcall;
function IDirectPlay4_SendChatMessage(idd : IDirectPlay4AW; idFrom : TDPID; idTo : TDPID; dwFlags : DWORD; var lpChatMessage : TDPChat) : HResult; stdcall;
function IDirectPlay4_SetGroupConnectionSettings(idd : IDirectPlay4AW; dwFlags : DWORD; idGroup : TDPID; var lpConnection : TDPLConnection) : HResult; stdcall;
function IDirectPlay4_StartSession(idd : IDirectPlay4AW; dwFlags : DWORD; idGroup : TDPID) : HResult; stdcall;
function IDirectPlay4_GetGroupFlags(idd : IDirectPlay4AW; idGroup : TDPID; var lpdwFlags : DWORD) : HResult; stdcall;
function IDirectPlay4_GetGroupParent(idd : IDirectPlay4AW; idGroup : TDPID; var lpidParent : TDPID) : HResult; stdcall;
function IDirectPlay4_GetPlayerAccount(idd : IDirectPlay4AW; idPlayer : TDPID; dwFlags : DWORD; var lpData; var lpdwDataSize : DWORD) : HResult; stdcall;
function IDirectPlay4_GetPlayerFlags(idd : IDirectPlay4AW; idPlayer : TDPID; var lpdwFlags : DWORD) : HResult; stdcall;
function IDirectPlay4_GetGroupOwner(idd : IDirectPlay4AW; idGroup : TDPID; var idOwner : TDPID) : HResult; stdcall;
function IDirectPlay4_SetGroupOwner(idd : IDirectPlay4AW; idGroup : TDPID; idOwner : TDPID) : HResult; stdcall;
function IDirectPlay4_SendEx(idd : IDirectPlay4AW; idFrom : TDPID; idTo : TDPID; dwFlags : DWORD; lpData : Pointer; dwDataSize : DWORD; dwPriority : DWORD; dwTimeout : DWORD; lpContext : Pointer; lpdwMsgId : PDWORD) : HResult; stdcall;
function IDirectPlay4_GetMessageQueue(idd : IDirectPlay4AW; idFrom : TDPID; idTo : TDPID; dwFlags : DWORD; lpdwNumMsgs : PDWORD; lpdwNumBytes : PDWORD) : HResult; stdcall;
function IDirectPlay4_CancelMessage(idd : IDirectPlay4AW; dwMessageID : DWORD; dwFlags : DWORD) : HResult; stdcall;
function IDirectPlay4_CancelPriority(idd : IDirectPlay4AW; dwMinPriority : DWORD; dwMaxPriority : DWORD; dwFlags : DWORD) : HResult; stdcall;

// IDirectPlay4W interface methods


// IDirectPlay4A interface methods


// IDirectPlay interface methods

function IDirectPlay_QueryInterface(idd : IDirectPlay; const IID : TGUID; var obj) : HRESULT; stdcall;
function IDirectPlay_AddRef(idd : IDirectPlay) : Longint; stdcall;
function IDirectPlay_Release(idd : IDirectPlay) : Longint; stdcall;
function IDirectPlay_AddPlayerToGroup(idd : IDirectPlay; pidGroup : TDPID; pidPlayer : TDPID) : HResult; stdcall;
function IDirectPlay_Close(idd : IDirectPlay) : HResult; stdcall;
function IDirectPlay_CreatePlayer(idd : IDirectPlay; var lppidID : TDPID; lpPlayerFriendlyName : PChar; lpPlayerFormalName : PChar; lpEvent : PHandle) : HResult; stdcall;
function IDirectPlay_CreateGroup(idd : IDirectPlay; var lppidID : TDPID; lpGroupFriendlyName : PChar; lpGroupFormalName : PChar) : HResult; stdcall;
function IDirectPlay_DeletePlayerFromGroup(idd : IDirectPlay; pidGroup : TDPID; pidPlayer : TDPID) : HResult; stdcall;
function IDirectPlay_DestroyPlayer(idd : IDirectPlay; pidID : TDPID) : HResult; stdcall;
function IDirectPlay_DestroyGroup(idd : IDirectPlay; pidID : TDPID) : HResult; stdcall;
function IDirectPlay_EnableNewPlayers(idd : IDirectPlay; bEnable : BOOL) : HResult; stdcall;
function IDirectPlay_EnumGroupPlayers(idd : IDirectPlay; pidGroupPID : TDPID; lpEnumPlayersCallback : TDPEnumPlayersCallback; lpContext : Pointer; dwFlags : DWORD) : HResult; stdcall;
function IDirectPlay_EnumGroups(idd : IDirectPlay; dwSessionID : DWORD; lpEnumPlayersCallback : TDPEnumPlayersCallback; lpContext : Pointer; dwFlags : DWORD) : HResult; stdcall;
function IDirectPlay_EnumPlayers(idd : IDirectPlay; dwSessionId : DWORD; lpEnumPlayersCallback : TDPEnumPlayersCallback; lpContext : Pointer; dwFlags : DWORD) : HResult; stdcall;
function IDirectPlay_EnumSessions(idd : IDirectPlay; var lpSDesc : TDPSessionDesc; dwTimeout : DWORD; lpEnumSessionsCallback : TDPEnumSessionsCallback; lpContext : Pointer; dwFlags : DWORD) : HResult; stdcall;
function IDirectPlay_GetCaps(idd : IDirectPlay; var lpDPCaps : TDPCaps) : HResult; stdcall;
function IDirectPlay_GetMessageCount(idd : IDirectPlay; pidID : TDPID; var lpdwCount : DWORD) : HResult; stdcall;
function IDirectPlay_GetPlayerCaps(idd : IDirectPlay; pidID : TDPID; var lpDPPlayerCaps : TDPCaps) : HResult; stdcall;
function IDirectPlay_GetPlayerName(idd : IDirectPlay; pidID : TDPID; lpPlayerFriendlyName : PChar; var lpdwFriendlyNameLength : DWORD; lpPlayerFormalName : PChar; var lpdwFormalNameLength : DWORD) : HResult; stdcall;
function IDirectPlay_Initialize(idd : IDirectPlay; const lpGUID : TGUID) : HResult; stdcall;
function IDirectPlay_Open(idd : IDirectPlay; var lpSDesc : TDPSessionDesc) : HResult; stdcall;
function IDirectPlay_Receive(idd : IDirectPlay; var lppidFrom , lppidTo : TDPID; dwFlags : DWORD; var lpvBuffer; var lpdwSize : DWORD) : HResult; stdcall;
function IDirectPlay_SaveSession(idd : IDirectPlay; lpSessionName : PChar) : HResult; stdcall;
function IDirectPlay_Send(idd : IDirectPlay; pidFrom : TDPID; pidTo : TDPID; dwFlags : DWORD; var lpvBuffer; dwBuffSize : DWORD) : HResult; stdcall;
function IDirectPlay_SetPlayerName(idd : IDirectPlay; pidID : TDPID; lpPlayerFriendlyName : PChar; lpPlayerFormalName : PChar) : HResult; stdcall;

// IDirectPlayLobbyAW interface methods

function IDirectPlayLobby_AddRef(idd : IDirectPlayLobbyAW) : Longint; stdcall;
function IDirectPlayLobby_Release(idd : IDirectPlayLobbyAW) : Longint; stdcall;
function IDirectPlayLobby_Connect(idd : IDirectPlayLobbyAW; dwFlags : DWORD; var lplpDP : IDirectPlay2; pUnk : IUnknown) : HResult; stdcall;
function IDirectPlayLobby_CreateAddress(idd : IDirectPlayLobbyAW; const guidSP , guidDataType : TGUID; var lpData; dwDataSize : DWORD; var lpAddress; var lpdwAddressSize : DWORD) : HResult; stdcall;
function IDirectPlayLobby_EnumAddress(idd : IDirectPlayLobbyAW; lpEnumAddressCallback : TDPEnumAdressCallback; var lpAddress; dwAddressSize : DWORD; lpContext : Pointer) : HResult; stdcall;
function IDirectPlayLobby_EnumAddressTypes(idd : IDirectPlayLobbyAW; lpEnumAddressTypeCallback : TDPLEnumAddressTypesCallback; const guidSP : TGUID; lpContext : Pointer; dwFlags : DWORD) : HResult; stdcall;
function IDirectPlayLobby_EnumLocalApplications(idd : IDirectPlayLobbyAW; lpEnumLocalAppCallback : TDPLEnumLocalApplicationsCallback; lpContext : Pointer; dwFlags : DWORD) : HResult; stdcall;
function IDirectPlayLobby_GetConnectionSettings(idd : IDirectPlayLobbyAW; dwAppID : DWORD; lpData : PDPLConnection; var lpdwDataSize : DWORD) : HResult; stdcall;
function IDirectPlayLobby_ReceiveLobbyMessage(idd : IDirectPlayLobbyAW; dwFlags : DWORD; dwAppID : DWORD; var lpdwMessageFlags : DWORD; lpData : Pointer; var lpdwDataSize : DWORD) : HResult; stdcall;
function IDirectPlayLobby_RunApplication(idd : IDirectPlayLobbyAW; dwFlags : DWORD; var lpdwAppId : DWORD; const lpConn : TDPLConnection; hReceiveEvent : THandle) : HResult; stdcall;
function IDirectPlayLobby_SendLobbyMessage(idd : IDirectPlayLobbyAW; dwFlags : DWORD; dwAppID : DWORD; const lpData; dwDataSize : DWORD) : HResult; stdcall;
function IDirectPlayLobby_SetConnectionSettings(idd : IDirectPlayLobbyAW; dwFlags : DWORD; dwAppID : DWORD; var lpConn : TDPLConnection) : HResult; stdcall;
function IDirectPlayLobby_SetLobbyMessageEvent(idd : IDirectPlayLobbyAW; dwFlags : DWORD; dwAppID : DWORD; hReceiveEvent : THandle) : HResult; stdcall;

// IDirectPlayLobbyW interface methods


// IDirectPlayLobbyA interface methods


// IDirectPlayLobby2AW interface methods

function IDirectPlayLobby2_AddRef(idd : IDirectPlayLobby2AW) : Longint; stdcall;
function IDirectPlayLobby2_Release(idd : IDirectPlayLobby2AW) : Longint; stdcall;
function IDirectPlayLobby2_Connect(idd : IDirectPlayLobby2AW; dwFlags : DWORD; var lplpDP : IDirectPlay2; pUnk : IUnknown) : HResult; stdcall;
function IDirectPlayLobby2_CreateAddress(idd : IDirectPlayLobby2AW; const guidSP , guidDataType : TGUID; var lpData; dwDataSize : DWORD; var lpAddress; var lpdwAddressSize : DWORD) : HResult; stdcall;
function IDirectPlayLobby2_EnumAddress(idd : IDirectPlayLobby2AW; lpEnumAddressCallback : TDPEnumAdressCallback; var lpAddress; dwAddressSize : DWORD; lpContext : Pointer) : HResult; stdcall;
function IDirectPlayLobby2_EnumAddressTypes(idd : IDirectPlayLobby2AW; lpEnumAddressTypeCallback : TDPLEnumAddressTypesCallback; const guidSP : TGUID; lpContext : Pointer; dwFlags : DWORD) : HResult; stdcall;
function IDirectPlayLobby2_EnumLocalApplications(idd : IDirectPlayLobby2AW; lpEnumLocalAppCallback : TDPLEnumLocalApplicationsCallback; lpContext : Pointer; dwFlags : DWORD) : HResult; stdcall;
function IDirectPlayLobby2_GetConnectionSettings(idd : IDirectPlayLobby2AW; dwAppID : DWORD; lpData : PDPLConnection; var lpdwDataSize : DWORD) : HResult; stdcall;
function IDirectPlayLobby2_ReceiveLobbyMessage(idd : IDirectPlayLobby2AW; dwFlags : DWORD; dwAppID : DWORD; var lpdwMessageFlags : DWORD; lpData : Pointer; var lpdwDataSize : DWORD) : HResult; stdcall;
function IDirectPlayLobby2_RunApplication(idd : IDirectPlayLobby2AW; dwFlags : DWORD; var lpdwAppId : DWORD; const lpConn : TDPLConnection; hReceiveEvent : THandle) : HResult; stdcall;
function IDirectPlayLobby2_SendLobbyMessage(idd : IDirectPlayLobby2AW; dwFlags : DWORD; dwAppID : DWORD; const lpData; dwDataSize : DWORD) : HResult; stdcall;
function IDirectPlayLobby2_SetConnectionSettings(idd : IDirectPlayLobby2AW; dwFlags : DWORD; dwAppID : DWORD; var lpConn : TDPLConnection) : HResult; stdcall;
function IDirectPlayLobby2_SetLobbyMessageEvent(idd : IDirectPlayLobby2AW; dwFlags : DWORD; dwAppID : DWORD; hReceiveEvent : THandle) : HResult; stdcall;
function IDirectPlayLobby2_CreateCompoundAddress(idd : IDirectPlayLobby2AW; const lpElements : TDPCompoundAddressElement; dwElementCount : DWORD; lpAddress : Pointer; var lpdwAddressSize : DWORD) : HResult; stdcall;

// IDirectPlayLobby2W interface methods


// IDirectPlayLobby2A interface methods


// IDirectPlayLobby3AW interface methods

function IDirectPlayLobby3_AddRef(idd : IDirectPlayLobby3AW) : Longint; stdcall;
function IDirectPlayLobby3_Release(idd : IDirectPlayLobby3AW) : Longint; stdcall;
function IDirectPlayLobby3_Connect(idd : IDirectPlayLobby3AW; dwFlags : DWORD; var lplpDP : IDirectPlay2; pUnk : IUnknown) : HResult; stdcall;
function IDirectPlayLobby3_CreateAddress(idd : IDirectPlayLobby3AW; const guidSP , guidDataType : TGUID; var lpData; dwDataSize : DWORD; var lpAddress; var lpdwAddressSize : DWORD) : HResult; stdcall;
function IDirectPlayLobby3_EnumAddress(idd : IDirectPlayLobby3AW; lpEnumAddressCallback : TDPEnumAdressCallback; var lpAddress; dwAddressSize : DWORD; lpContext : Pointer) : HResult; stdcall;
function IDirectPlayLobby3_EnumAddressTypes(idd : IDirectPlayLobby3AW; lpEnumAddressTypeCallback : TDPLEnumAddressTypesCallback; const guidSP : TGUID; lpContext : Pointer; dwFlags : DWORD) : HResult; stdcall;
function IDirectPlayLobby3_EnumLocalApplications(idd : IDirectPlayLobby3AW; lpEnumLocalAppCallback : TDPLEnumLocalApplicationsCallback; lpContext : Pointer; dwFlags : DWORD) : HResult; stdcall;
function IDirectPlayLobby3_GetConnectionSettings(idd : IDirectPlayLobby3AW; dwAppID : DWORD; lpData : PDPLConnection; var lpdwDataSize : DWORD) : HResult; stdcall;
function IDirectPlayLobby3_ReceiveLobbyMessage(idd : IDirectPlayLobby3AW; dwFlags : DWORD; dwAppID : DWORD; var lpdwMessageFlags : DWORD; lpData : Pointer; var lpdwDataSize : DWORD) : HResult; stdcall;
function IDirectPlayLobby3_RunApplication(idd : IDirectPlayLobby3AW; dwFlags : DWORD; var lpdwAppId : DWORD; const lpConn : TDPLConnection; hReceiveEvent : THandle) : HResult; stdcall;
function IDirectPlayLobby3_SendLobbyMessage(idd : IDirectPlayLobby3AW; dwFlags : DWORD; dwAppID : DWORD; const lpData; dwDataSize : DWORD) : HResult; stdcall;
function IDirectPlayLobby3_SetConnectionSettings(idd : IDirectPlayLobby3AW; dwFlags : DWORD; dwAppID : DWORD; var lpConn : TDPLConnection) : HResult; stdcall;
function IDirectPlayLobby3_SetLobbyMessageEvent(idd : IDirectPlayLobby3AW; dwFlags : DWORD; dwAppID : DWORD; hReceiveEvent : THandle) : HResult; stdcall;
function IDirectPlayLobby3_CreateCompoundAddress(idd : IDirectPlayLobby3AW; const lpElements : TDPCompoundAddressElement; dwElementCount : DWORD; lpAddress : Pointer; var lpdwAddressSize : DWORD) : HResult; stdcall;
function IDirectPlayLobby3_ConnectEx(idd : IDirectPlayLobby3AW; dwFlags : DWORD; const riid : TGUID; var lplpDP; pUnk : IUnknown) : HResult; stdcall;
function IDirectPlayLobby3_RegisterApplication(idd : IDirectPlayLobby3AW; dwFlags : DWORD; var lpAppDesc : TDPApplicationDesc) : HResult; stdcall;
function IDirectPlayLobby3_UnregisterApplication(idd : IDirectPlayLobby3AW; dwFlags : DWORD; const guidApplication : TGUID) : HResult; stdcall;
function IDirectPlayLobby3_WaitForConnectionSettings(idd : IDirectPlayLobby3AW; dwFlags : DWORD) : HResult; stdcall;

// IDirectPlayLobby3W interface methods


// IDirectPlayLobby3A interface methods


implementation


// IDirectPlay2AW interface methods

function IDirectPlay2_AddRef(idd : IDirectPlay2AW) : Longint; stdcall;
begin
	result := idd^^.AddRef(idd);
end;

function IDirectPlay2_Release(idd : IDirectPlay2AW) : Longint; stdcall;
begin
	result := idd^^.Release(idd);
end;

function IDirectPlay2_AddPlayerToGroup(idd : IDirectPlay2AW; idGroup : TDPID; idPlayer : TDPID) : HResult; stdcall;
begin
	result := idd^^.AddPlayerToGroup(idd, idGroup, idPlayer);
end;

function IDirectPlay2_Close(idd : IDirectPlay2AW) : HResult; stdcall;
begin
	result := idd^^.Close(idd);
end;

function IDirectPlay2_CreateGroup(idd : IDirectPlay2AW; var lpidGroup : TDPID; lpGroupName : PDPName; lpData : Pointer; dwDataSize : DWORD; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.CreateGroup(idd, lpidGroup, lpGroupName, lpData, dwDataSize, dwFlags);
end;

function IDirectPlay2_CreatePlayer(idd : IDirectPlay2AW; var lpidPlayer : TDPID; pPlayerName : PDPName; hEvent : THandle; lpData : Pointer; dwDataSize : DWORD; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.CreatePlayer(idd, lpidPlayer, pPlayerName, hEvent, lpData, dwDataSize, dwFlags);
end;

function IDirectPlay2_DeletePlayerFromGroup(idd : IDirectPlay2AW; idGroup : TDPID; idPlayer : TDPID) : HResult; stdcall;
begin
	result := idd^^.DeletePlayerFromGroup(idd, idGroup, idPlayer);
end;

function IDirectPlay2_DestroyGroup(idd : IDirectPlay2AW; idGroup : TDPID) : HResult; stdcall;
begin
	result := idd^^.DestroyGroup(idd, idGroup);
end;

function IDirectPlay2_DestroyPlayer(idd : IDirectPlay2AW; idPlayer : TDPID) : HResult; stdcall;
begin
	result := idd^^.DestroyPlayer(idd, idPlayer);
end;

function IDirectPlay2_EnumGroupPlayers(idd : IDirectPlay2AW; idGroup : TDPID; lpguidInstance : PGUID; lpEnumPlayersCallback2 : TDPEnumPlayersCallback2; lpContext : Pointer; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.EnumGroupPlayers(idd, idGroup, lpguidInstance, @lpEnumPlayersCallback2, lpContext, dwFlags);
end;

function IDirectPlay2_EnumGroups(idd : IDirectPlay2AW; lpguidInstance : PGUID; lpEnumPlayersCallback2 : TDPEnumPlayersCallback2; lpContext : Pointer; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.EnumGroups(idd, lpguidInstance, @lpEnumPlayersCallback2, lpContext, dwFlags);
end;

function IDirectPlay2_EnumPlayers(idd : IDirectPlay2AW; lpguidInstance : PGUID; lpEnumPlayersCallback2 : TDPEnumPlayersCallback2; lpContext : Pointer; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.EnumPlayers(idd, lpguidInstance, @lpEnumPlayersCallback2, lpContext, dwFlags);
end;

function IDirectPlay2_EnumSessions(idd : IDirectPlay2AW; const lpsd : TDPSessionDesc2; dwTimeout : DWORD; lpEnumSessionsCallback2 : TDPEnumSessionsCallback2; lpContext : Pointer; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.EnumSessions(idd, lpsd, dwTimeout, @lpEnumSessionsCallback2, lpContext, dwFlags);
end;

function IDirectPlay2_GetCaps(idd : IDirectPlay2AW; var lpDPCaps : TDPCaps; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.GetCaps(idd, lpDPCaps, dwFlags);
end;

function IDirectPlay2_GetGroupData(idd : IDirectPlay2AW; idGroup : TDPID; lpData : Pointer; var lpdwDataSize : DWORD; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.GetGroupData(idd, idGroup, lpData, lpdwDataSize, dwFlags);
end;

function IDirectPlay2_GetGroupName(idd : IDirectPlay2AW; idGroup : TDPID; lpData : Pointer; var lpdwDataSize : DWORD) : HResult; stdcall;
begin
	result := idd^^.GetGroupName(idd, idGroup, lpData, lpdwDataSize);
end;

function IDirectPlay2_GetMessageCount(idd : IDirectPlay2AW; idPlayer : TDPID; var lpdwCount : DWORD) : HResult; stdcall;
begin
	result := idd^^.GetMessageCount(idd, idPlayer, lpdwCount);
end;

function IDirectPlay2_GetPlayerAddress(idd : IDirectPlay2AW; idPlayer : TDPID; lpAddress : Pointer; var lpdwAddressSize : DWORD) : HResult; stdcall;
begin
	result := idd^^.GetPlayerAddress(idd, idPlayer, lpAddress, lpdwAddressSize);
end;

function IDirectPlay2_GetPlayerCaps(idd : IDirectPlay2AW; idPlayer : TDPID; var lpPlayerCaps : TDPCaps; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.GetPlayerCaps(idd, idPlayer, lpPlayerCaps, dwFlags);
end;

function IDirectPlay2_GetPlayerData(idd : IDirectPlay2AW; idPlayer : TDPID; lpData : Pointer; var lpdwDataSize : DWORD; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.GetPlayerData(idd, idPlayer, lpData, lpdwDataSize, dwFlags);
end;

function IDirectPlay2_GetPlayerName(idd : IDirectPlay2AW; idPlayer : TDPID; lpData : Pointer; var lpdwDataSize : DWORD) : HResult; stdcall;
begin
	result := idd^^.GetPlayerName(idd, idPlayer, lpData, lpdwDataSize);
end;

function IDirectPlay2_GetSessionDesc(idd : IDirectPlay2AW; lpData : Pointer; var lpdwDataSize : DWORD) : HResult; stdcall;
begin
	result := idd^^.GetSessionDesc(idd, lpData, lpdwDataSize);
end;

function IDirectPlay2_Initialize(idd : IDirectPlay2AW; const lpGUID : TGUID) : HResult; stdcall;
begin
	result := idd^^.Initialize(idd, lpGUID);
end;

function IDirectPlay2_Open(idd : IDirectPlay2AW; var lpsd : TDPSessionDesc2; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.Open(idd, lpsd, dwFlags);
end;

function IDirectPlay2_Receive(idd : IDirectPlay2AW; var lpidFrom : TDPID; var lpidTo : TDPID; dwFlags : DWORD; lpData : Pointer; var lpdwDataSize : DWORD) : HResult; stdcall;
begin
	result := idd^^.Receive(idd, lpidFrom, lpidTo, dwFlags, lpData, lpdwDataSize);
end;

function IDirectPlay2_Send(idd : IDirectPlay2AW; idFrom : TDPID; lpidTo : TDPID; dwFlags : DWORD; var lpData; lpdwDataSize : DWORD) : HResult; stdcall;
begin
	result := idd^^.Send(idd, idFrom, lpidTo, dwFlags, lpData, lpdwDataSize);
end;

function IDirectPlay2_SetGroupData(idd : IDirectPlay2AW; idGroup : TDPID; lpData : Pointer; dwDataSize : DWORD; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.SetGroupData(idd, idGroup, lpData, dwDataSize, dwFlags);
end;

function IDirectPlay2_SetGroupName(idd : IDirectPlay2AW; idGroup : TDPID; lpGroupName : PDPName; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.SetGroupName(idd, idGroup, lpGroupName, dwFlags);
end;

function IDirectPlay2_SetPlayerData(idd : IDirectPlay2AW; idPlayer : TDPID; lpData : Pointer; dwDataSize : DWORD; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.SetPlayerData(idd, idPlayer, lpData, dwDataSize, dwFlags);
end;

function IDirectPlay2_SetPlayerName(idd : IDirectPlay2AW; idPlayer : TDPID; lpPlayerName : PDPName; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.SetPlayerName(idd, idPlayer, lpPlayerName, dwFlags);
end;

function IDirectPlay2_SetSessionDesc(idd : IDirectPlay2AW; var lpSessDesc : TDPSessionDesc2; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.SetSessionDesc(idd, lpSessDesc, dwFlags);
end;


// IDirectPlay2W interface methods


// IDirectPlay2A interface methods


// IDirectPlay3AW interface methods

function IDirectPlay3_AddRef(idd : IDirectPlay3AW) : Longint; stdcall;
begin
	result := idd^^.AddRef(idd);
end;

function IDirectPlay3_Release(idd : IDirectPlay3AW) : Longint; stdcall;
begin
	result := idd^^.Release(idd);
end;

function IDirectPlay3_AddPlayerToGroup(idd : IDirectPlay3AW; idGroup : TDPID; idPlayer : TDPID) : HResult; stdcall;
begin
	result := idd^^.AddPlayerToGroup(idd, idGroup, idPlayer);
end;

function IDirectPlay3_Close(idd : IDirectPlay3AW) : HResult; stdcall;
begin
	result := idd^^.Close(idd);
end;

function IDirectPlay3_CreateGroup(idd : IDirectPlay3AW; var lpidGroup : TDPID; lpGroupName : PDPName; lpData : Pointer; dwDataSize : DWORD; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.CreateGroup(idd, lpidGroup, lpGroupName, lpData, dwDataSize, dwFlags);
end;

function IDirectPlay3_CreatePlayer(idd : IDirectPlay3AW; var lpidPlayer : TDPID; pPlayerName : PDPName; hEvent : THandle; lpData : Pointer; dwDataSize : DWORD; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.CreatePlayer(idd, lpidPlayer, pPlayerName, hEvent, lpData, dwDataSize, dwFlags);
end;

function IDirectPlay3_DeletePlayerFromGroup(idd : IDirectPlay3AW; idGroup : TDPID; idPlayer : TDPID) : HResult; stdcall;
begin
	result := idd^^.DeletePlayerFromGroup(idd, idGroup, idPlayer);
end;

function IDirectPlay3_DestroyGroup(idd : IDirectPlay3AW; idGroup : TDPID) : HResult; stdcall;
begin
	result := idd^^.DestroyGroup(idd, idGroup);
end;

function IDirectPlay3_DestroyPlayer(idd : IDirectPlay3AW; idPlayer : TDPID) : HResult; stdcall;
begin
	result := idd^^.DestroyPlayer(idd, idPlayer);
end;

function IDirectPlay3_EnumGroupPlayers(idd : IDirectPlay3AW; idGroup : TDPID; lpguidInstance : PGUID; lpEnumPlayersCallback2 : TDPEnumPlayersCallback2; lpContext : Pointer; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.EnumGroupPlayers(idd, idGroup, lpguidInstance, @lpEnumPlayersCallback2, lpContext, dwFlags);
end;

function IDirectPlay3_EnumGroups(idd : IDirectPlay3AW; lpguidInstance : PGUID; lpEnumPlayersCallback2 : TDPEnumPlayersCallback2; lpContext : Pointer; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.EnumGroups(idd, lpguidInstance, @lpEnumPlayersCallback2, lpContext, dwFlags);
end;

function IDirectPlay3_EnumPlayers(idd : IDirectPlay3AW; lpguidInstance : PGUID; lpEnumPlayersCallback2 : TDPEnumPlayersCallback2; lpContext : Pointer; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.EnumPlayers(idd, lpguidInstance, @lpEnumPlayersCallback2, lpContext, dwFlags);
end;

function IDirectPlay3_EnumSessions(idd : IDirectPlay3AW; const lpsd : TDPSessionDesc2; dwTimeout : DWORD; lpEnumSessionsCallback2 : TDPEnumSessionsCallback2; lpContext : Pointer; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.EnumSessions(idd, lpsd, dwTimeout, @lpEnumSessionsCallback2, lpContext, dwFlags);
end;

function IDirectPlay3_GetCaps(idd : IDirectPlay3AW; var lpDPCaps : TDPCaps; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.GetCaps(idd, lpDPCaps, dwFlags);
end;

function IDirectPlay3_GetGroupData(idd : IDirectPlay3AW; idGroup : TDPID; lpData : Pointer; var lpdwDataSize : DWORD; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.GetGroupData(idd, idGroup, lpData, lpdwDataSize, dwFlags);
end;

function IDirectPlay3_GetGroupName(idd : IDirectPlay3AW; idGroup : TDPID; lpData : Pointer; var lpdwDataSize : DWORD) : HResult; stdcall;
begin
	result := idd^^.GetGroupName(idd, idGroup, lpData, lpdwDataSize);
end;

function IDirectPlay3_GetMessageCount(idd : IDirectPlay3AW; idPlayer : TDPID; var lpdwCount : DWORD) : HResult; stdcall;
begin
	result := idd^^.GetMessageCount(idd, idPlayer, lpdwCount);
end;

function IDirectPlay3_GetPlayerAddress(idd : IDirectPlay3AW; idPlayer : TDPID; lpAddress : Pointer; var lpdwAddressSize : DWORD) : HResult; stdcall;
begin
	result := idd^^.GetPlayerAddress(idd, idPlayer, lpAddress, lpdwAddressSize);
end;

function IDirectPlay3_GetPlayerCaps(idd : IDirectPlay3AW; idPlayer : TDPID; var lpPlayerCaps : TDPCaps; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.GetPlayerCaps(idd, idPlayer, lpPlayerCaps, dwFlags);
end;

function IDirectPlay3_GetPlayerData(idd : IDirectPlay3AW; idPlayer : TDPID; lpData : Pointer; var lpdwDataSize : DWORD; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.GetPlayerData(idd, idPlayer, lpData, lpdwDataSize, dwFlags);
end;

function IDirectPlay3_GetPlayerName(idd : IDirectPlay3AW; idPlayer : TDPID; lpData : Pointer; var lpdwDataSize : DWORD) : HResult; stdcall;
begin
	result := idd^^.GetPlayerName(idd, idPlayer, lpData, lpdwDataSize);
end;

function IDirectPlay3_GetSessionDesc(idd : IDirectPlay3AW; lpData : Pointer; var lpdwDataSize : DWORD) : HResult; stdcall;
begin
	result := idd^^.GetSessionDesc(idd, lpData, lpdwDataSize);
end;

function IDirectPlay3_Initialize(idd : IDirectPlay3AW; const lpGUID : TGUID) : HResult; stdcall;
begin
	result := idd^^.Initialize(idd, lpGUID);
end;

function IDirectPlay3_Open(idd : IDirectPlay3AW; var lpsd : TDPSessionDesc2; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.Open(idd, lpsd, dwFlags);
end;

function IDirectPlay3_Receive(idd : IDirectPlay3AW; var lpidFrom : TDPID; var lpidTo : TDPID; dwFlags : DWORD; lpData : Pointer; var lpdwDataSize : DWORD) : HResult; stdcall;
begin
	result := idd^^.Receive(idd, lpidFrom, lpidTo, dwFlags, lpData, lpdwDataSize);
end;

function IDirectPlay3_Send(idd : IDirectPlay3AW; idFrom : TDPID; lpidTo : TDPID; dwFlags : DWORD; var lpData; lpdwDataSize : DWORD) : HResult; stdcall;
begin
	result := idd^^.Send(idd, idFrom, lpidTo, dwFlags, lpData, lpdwDataSize);
end;

function IDirectPlay3_SetGroupData(idd : IDirectPlay3AW; idGroup : TDPID; lpData : Pointer; dwDataSize : DWORD; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.SetGroupData(idd, idGroup, lpData, dwDataSize, dwFlags);
end;

function IDirectPlay3_SetGroupName(idd : IDirectPlay3AW; idGroup : TDPID; lpGroupName : PDPName; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.SetGroupName(idd, idGroup, lpGroupName, dwFlags);
end;

function IDirectPlay3_SetPlayerData(idd : IDirectPlay3AW; idPlayer : TDPID; lpData : Pointer; dwDataSize : DWORD; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.SetPlayerData(idd, idPlayer, lpData, dwDataSize, dwFlags);
end;

function IDirectPlay3_SetPlayerName(idd : IDirectPlay3AW; idPlayer : TDPID; lpPlayerName : PDPName; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.SetPlayerName(idd, idPlayer, lpPlayerName, dwFlags);
end;

function IDirectPlay3_SetSessionDesc(idd : IDirectPlay3AW; var lpSessDesc : TDPSessionDesc2; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.SetSessionDesc(idd, lpSessDesc, dwFlags);
end;

function IDirectPlay3_AddGroupToGroup(idd : IDirectPlay3AW; idParentGroup : TDPID; idGroup : TDPID) : HResult; stdcall;
begin
	result := idd^^.AddGroupToGroup(idd, idParentGroup, idGroup);
end;

function IDirectPlay3_CreateGroupInGroup(idd : IDirectPlay3AW; idParentGroup : TDPID; var lpidGroup : TDPID; lpGroupName : PDPName; lpData : Pointer; dwDataSize : DWORD; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.CreateGroupInGroup(idd, idParentGroup, lpidGroup, lpGroupName, lpData, dwDataSize, dwFlags);
end;

function IDirectPlay3_DeleteGroupFromGroup(idd : IDirectPlay3AW; idParentGroup : TDPID; idGroup : TDPID) : HResult; stdcall;
begin
	result := idd^^.DeleteGroupFromGroup(idd, idParentGroup, idGroup);
end;

function IDirectPlay3_EnumConnections(idd : IDirectPlay3AW; lpguidApplication : PGUID; lpEnumCallback : TDPEnumConnectionsCallback; lpContext : Pointer; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.EnumConnections(idd, lpguidApplication, @lpEnumCallback, lpContext, dwFlags);
end;

function IDirectPlay3_EnumGroupsInGroup(idd : IDirectPlay3AW; idGroup : TDPID; lpguidInstance : PGUID; lpEnumPlayersCallback2 : TDPEnumPlayersCallback2; lpContext : Pointer; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.EnumGroupsInGroup(idd, idGroup, lpguidInstance, @lpEnumPlayersCallback2, lpContext, dwFlags);
end;

function IDirectPlay3_GetGroupConnectionSettings(idd : IDirectPlay3AW; dwFlags : DWORD; idGroup : TDPID; lpData : Pointer; var lpdwDataSize : DWORD) : HResult; stdcall;
begin
	result := idd^^.GetGroupConnectionSettings(idd, dwFlags, idGroup, lpData, lpdwDataSize);
end;

function IDirectPlay3_InitializeConnection(idd : IDirectPlay3AW; lpConnection : Pointer; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.InitializeConnection(idd, lpConnection, dwFlags);
end;

function IDirectPlay3_SecureOpen(idd : IDirectPlay3AW; var lpsd : TDPSessionDesc2; dwFlags : DWORD; var lpSecurity : TDPSecurityDesc; var lpCredentials : TDPCredentials) : HResult; stdcall;
begin
	result := idd^^.SecureOpen(idd, lpsd, dwFlags, lpSecurity, lpCredentials);
end;

function IDirectPlay3_SendChatMessage(idd : IDirectPlay3AW; idFrom : TDPID; idTo : TDPID; dwFlags : DWORD; var lpChatMessage : TDPChat) : HResult; stdcall;
begin
	result := idd^^.SendChatMessage(idd, idFrom, idTo, dwFlags, lpChatMessage);
end;

function IDirectPlay3_SetGroupConnectionSettings(idd : IDirectPlay3AW; dwFlags : DWORD; idGroup : TDPID; var lpConnection : TDPLConnection) : HResult; stdcall;
begin
	result := idd^^.SetGroupConnectionSettings(idd, dwFlags, idGroup, lpConnection);
end;

function IDirectPlay3_StartSession(idd : IDirectPlay3AW; dwFlags : DWORD; idGroup : TDPID) : HResult; stdcall;
begin
	result := idd^^.StartSession(idd, dwFlags, idGroup);
end;

function IDirectPlay3_GetGroupFlags(idd : IDirectPlay3AW; idGroup : TDPID; var lpdwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.GetGroupFlags(idd, idGroup, lpdwFlags);
end;

function IDirectPlay3_GetGroupParent(idd : IDirectPlay3AW; idGroup : TDPID; var lpidParent : TDPID) : HResult; stdcall;
begin
	result := idd^^.GetGroupParent(idd, idGroup, lpidParent);
end;

function IDirectPlay3_GetPlayerAccount(idd : IDirectPlay3AW; idPlayer : TDPID; dwFlags : DWORD; var lpData; var lpdwDataSize : DWORD) : HResult; stdcall;
begin
	result := idd^^.GetPlayerAccount(idd, idPlayer, dwFlags, lpData, lpdwDataSize);
end;

function IDirectPlay3_GetPlayerFlags(idd : IDirectPlay3AW; idPlayer : TDPID; var lpdwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.GetPlayerFlags(idd, idPlayer, lpdwFlags);
end;


// IDirectPlay3W interface methods


// IDirectPlay3A interface methods


// IDirectPlay4AW interface methods

function IDirectPlay4_AddRef(idd : IDirectPlay4AW) : Longint; stdcall;
begin
	result := idd^^.AddRef(idd);
end;

function IDirectPlay4_Release(idd : IDirectPlay4AW) : Longint; stdcall;
begin
	result := idd^^.Release(idd);
end;

function IDirectPlay4_AddPlayerToGroup(idd : IDirectPlay4AW; idGroup : TDPID; idPlayer : TDPID) : HResult; stdcall;
begin
	result := idd^^.AddPlayerToGroup(idd, idGroup, idPlayer);
end;

function IDirectPlay4_Close(idd : IDirectPlay4AW) : HResult; stdcall;
begin
	result := idd^^.Close(idd);
end;

function IDirectPlay4_CreateGroup(idd : IDirectPlay4AW; var lpidGroup : TDPID; lpGroupName : PDPName; lpData : Pointer; dwDataSize : DWORD; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.CreateGroup(idd, lpidGroup, lpGroupName, lpData, dwDataSize, dwFlags);
end;

function IDirectPlay4_CreatePlayer(idd : IDirectPlay4AW; var lpidPlayer : TDPID; pPlayerName : PDPName; hEvent : THandle; lpData : Pointer; dwDataSize : DWORD; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.CreatePlayer(idd, lpidPlayer, pPlayerName, hEvent, lpData, dwDataSize, dwFlags);
end;

function IDirectPlay4_DeletePlayerFromGroup(idd : IDirectPlay4AW; idGroup : TDPID; idPlayer : TDPID) : HResult; stdcall;
begin
	result := idd^^.DeletePlayerFromGroup(idd, idGroup, idPlayer);
end;

function IDirectPlay4_DestroyGroup(idd : IDirectPlay4AW; idGroup : TDPID) : HResult; stdcall;
begin
	result := idd^^.DestroyGroup(idd, idGroup);
end;

function IDirectPlay4_DestroyPlayer(idd : IDirectPlay4AW; idPlayer : TDPID) : HResult; stdcall;
begin
	result := idd^^.DestroyPlayer(idd, idPlayer);
end;

function IDirectPlay4_EnumGroupPlayers(idd : IDirectPlay4AW; idGroup : TDPID; lpguidInstance : PGUID; lpEnumPlayersCallback2 : TDPEnumPlayersCallback2; lpContext : Pointer; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.EnumGroupPlayers(idd, idGroup, lpguidInstance, @lpEnumPlayersCallback2, lpContext, dwFlags);
end;

function IDirectPlay4_EnumGroups(idd : IDirectPlay4AW; lpguidInstance : PGUID; lpEnumPlayersCallback2 : TDPEnumPlayersCallback2; lpContext : Pointer; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.EnumGroups(idd, lpguidInstance, @lpEnumPlayersCallback2, lpContext, dwFlags);
end;

function IDirectPlay4_EnumPlayers(idd : IDirectPlay4AW; lpguidInstance : PGUID; lpEnumPlayersCallback2 : TDPEnumPlayersCallback2; lpContext : Pointer; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.EnumPlayers(idd, lpguidInstance, @lpEnumPlayersCallback2, lpContext, dwFlags);
end;

function IDirectPlay4_EnumSessions(idd : IDirectPlay4AW; const lpsd : TDPSessionDesc2; dwTimeout : DWORD; lpEnumSessionsCallback2 : TDPEnumSessionsCallback2; lpContext : Pointer; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.EnumSessions(idd, lpsd, dwTimeout, @lpEnumSessionsCallback2, lpContext, dwFlags);
end;

function IDirectPlay4_GetCaps(idd : IDirectPlay4AW; var lpDPCaps : TDPCaps; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.GetCaps(idd, lpDPCaps, dwFlags);
end;

function IDirectPlay4_GetGroupData(idd : IDirectPlay4AW; idGroup : TDPID; lpData : Pointer; var lpdwDataSize : DWORD; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.GetGroupData(idd, idGroup, lpData, lpdwDataSize, dwFlags);
end;

function IDirectPlay4_GetGroupName(idd : IDirectPlay4AW; idGroup : TDPID; lpData : Pointer; var lpdwDataSize : DWORD) : HResult; stdcall;
begin
	result := idd^^.GetGroupName(idd, idGroup, lpData, lpdwDataSize);
end;

function IDirectPlay4_GetMessageCount(idd : IDirectPlay4AW; idPlayer : TDPID; var lpdwCount : DWORD) : HResult; stdcall;
begin
	result := idd^^.GetMessageCount(idd, idPlayer, lpdwCount);
end;

function IDirectPlay4_GetPlayerAddress(idd : IDirectPlay4AW; idPlayer : TDPID; lpAddress : Pointer; var lpdwAddressSize : DWORD) : HResult; stdcall;
begin
	result := idd^^.GetPlayerAddress(idd, idPlayer, lpAddress, lpdwAddressSize);
end;

function IDirectPlay4_GetPlayerCaps(idd : IDirectPlay4AW; idPlayer : TDPID; var lpPlayerCaps : TDPCaps; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.GetPlayerCaps(idd, idPlayer, lpPlayerCaps, dwFlags);
end;

function IDirectPlay4_GetPlayerData(idd : IDirectPlay4AW; idPlayer : TDPID; lpData : Pointer; var lpdwDataSize : DWORD; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.GetPlayerData(idd, idPlayer, lpData, lpdwDataSize, dwFlags);
end;

function IDirectPlay4_GetPlayerName(idd : IDirectPlay4AW; idPlayer : TDPID; lpData : Pointer; var lpdwDataSize : DWORD) : HResult; stdcall;
begin
	result := idd^^.GetPlayerName(idd, idPlayer, lpData, lpdwDataSize);
end;

function IDirectPlay4_GetSessionDesc(idd : IDirectPlay4AW; lpData : Pointer; var lpdwDataSize : DWORD) : HResult; stdcall;
begin
	result := idd^^.GetSessionDesc(idd, lpData, lpdwDataSize);
end;

function IDirectPlay4_Initialize(idd : IDirectPlay4AW; const lpGUID : TGUID) : HResult; stdcall;
begin
	result := idd^^.Initialize(idd, lpGUID);
end;

function IDirectPlay4_Open(idd : IDirectPlay4AW; var lpsd : TDPSessionDesc2; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.Open(idd, lpsd, dwFlags);
end;

function IDirectPlay4_Receive(idd : IDirectPlay4AW; var lpidFrom : TDPID; var lpidTo : TDPID; dwFlags : DWORD; lpData : Pointer; var lpdwDataSize : DWORD) : HResult; stdcall;
begin
	result := idd^^.Receive(idd, lpidFrom, lpidTo, dwFlags, lpData, lpdwDataSize);
end;

function IDirectPlay4_Send(idd : IDirectPlay4AW; idFrom : TDPID; lpidTo : TDPID; dwFlags : DWORD; var lpData; lpdwDataSize : DWORD) : HResult; stdcall;
begin
	result := idd^^.Send(idd, idFrom, lpidTo, dwFlags, lpData, lpdwDataSize);
end;

function IDirectPlay4_SetGroupData(idd : IDirectPlay4AW; idGroup : TDPID; lpData : Pointer; dwDataSize : DWORD; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.SetGroupData(idd, idGroup, lpData, dwDataSize, dwFlags);
end;

function IDirectPlay4_SetGroupName(idd : IDirectPlay4AW; idGroup : TDPID; lpGroupName : PDPName; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.SetGroupName(idd, idGroup, lpGroupName, dwFlags);
end;

function IDirectPlay4_SetPlayerData(idd : IDirectPlay4AW; idPlayer : TDPID; lpData : Pointer; dwDataSize : DWORD; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.SetPlayerData(idd, idPlayer, lpData, dwDataSize, dwFlags);
end;

function IDirectPlay4_SetPlayerName(idd : IDirectPlay4AW; idPlayer : TDPID; lpPlayerName : PDPName; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.SetPlayerName(idd, idPlayer, lpPlayerName, dwFlags);
end;

function IDirectPlay4_SetSessionDesc(idd : IDirectPlay4AW; var lpSessDesc : TDPSessionDesc2; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.SetSessionDesc(idd, lpSessDesc, dwFlags);
end;

function IDirectPlay4_AddGroupToGroup(idd : IDirectPlay4AW; idParentGroup : TDPID; idGroup : TDPID) : HResult; stdcall;
begin
	result := idd^^.AddGroupToGroup(idd, idParentGroup, idGroup);
end;

function IDirectPlay4_CreateGroupInGroup(idd : IDirectPlay4AW; idParentGroup : TDPID; var lpidGroup : TDPID; lpGroupName : PDPName; lpData : Pointer; dwDataSize : DWORD; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.CreateGroupInGroup(idd, idParentGroup, lpidGroup, lpGroupName, lpData, dwDataSize, dwFlags);
end;

function IDirectPlay4_DeleteGroupFromGroup(idd : IDirectPlay4AW; idParentGroup : TDPID; idGroup : TDPID) : HResult; stdcall;
begin
	result := idd^^.DeleteGroupFromGroup(idd, idParentGroup, idGroup);
end;

function IDirectPlay4_EnumConnections(idd : IDirectPlay4AW; lpguidApplication : PGUID; lpEnumCallback : TDPEnumConnectionsCallback; lpContext : Pointer; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.EnumConnections(idd, lpguidApplication, @lpEnumCallback, lpContext, dwFlags);
end;

function IDirectPlay4_EnumGroupsInGroup(idd : IDirectPlay4AW; idGroup : TDPID; lpguidInstance : PGUID; lpEnumPlayersCallback2 : TDPEnumPlayersCallback2; lpContext : Pointer; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.EnumGroupsInGroup(idd, idGroup, lpguidInstance, @lpEnumPlayersCallback2, lpContext, dwFlags);
end;

function IDirectPlay4_GetGroupConnectionSettings(idd : IDirectPlay4AW; dwFlags : DWORD; idGroup : TDPID; lpData : Pointer; var lpdwDataSize : DWORD) : HResult; stdcall;
begin
	result := idd^^.GetGroupConnectionSettings(idd, dwFlags, idGroup, lpData, lpdwDataSize);
end;

function IDirectPlay4_InitializeConnection(idd : IDirectPlay4AW; lpConnection : Pointer; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.InitializeConnection(idd, lpConnection, dwFlags);
end;

function IDirectPlay4_SecureOpen(idd : IDirectPlay4AW; var lpsd : TDPSessionDesc2; dwFlags : DWORD; var lpSecurity : TDPSecurityDesc; var lpCredentials : TDPCredentials) : HResult; stdcall;
begin
	result := idd^^.SecureOpen(idd, lpsd, dwFlags, lpSecurity, lpCredentials);
end;

function IDirectPlay4_SendChatMessage(idd : IDirectPlay4AW; idFrom : TDPID; idTo : TDPID; dwFlags : DWORD; var lpChatMessage : TDPChat) : HResult; stdcall;
begin
	result := idd^^.SendChatMessage(idd, idFrom, idTo, dwFlags, lpChatMessage);
end;

function IDirectPlay4_SetGroupConnectionSettings(idd : IDirectPlay4AW; dwFlags : DWORD; idGroup : TDPID; var lpConnection : TDPLConnection) : HResult; stdcall;
begin
	result := idd^^.SetGroupConnectionSettings(idd, dwFlags, idGroup, lpConnection);
end;

function IDirectPlay4_StartSession(idd : IDirectPlay4AW; dwFlags : DWORD; idGroup : TDPID) : HResult; stdcall;
begin
	result := idd^^.StartSession(idd, dwFlags, idGroup);
end;

function IDirectPlay4_GetGroupFlags(idd : IDirectPlay4AW; idGroup : TDPID; var lpdwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.GetGroupFlags(idd, idGroup, lpdwFlags);
end;

function IDirectPlay4_GetGroupParent(idd : IDirectPlay4AW; idGroup : TDPID; var lpidParent : TDPID) : HResult; stdcall;
begin
	result := idd^^.GetGroupParent(idd, idGroup, lpidParent);
end;

function IDirectPlay4_GetPlayerAccount(idd : IDirectPlay4AW; idPlayer : TDPID; dwFlags : DWORD; var lpData; var lpdwDataSize : DWORD) : HResult; stdcall;
begin
	result := idd^^.GetPlayerAccount(idd, idPlayer, dwFlags, lpData, lpdwDataSize);
end;

function IDirectPlay4_GetPlayerFlags(idd : IDirectPlay4AW; idPlayer : TDPID; var lpdwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.GetPlayerFlags(idd, idPlayer, lpdwFlags);
end;

function IDirectPlay4_GetGroupOwner(idd : IDirectPlay4AW; idGroup : TDPID; var idOwner : TDPID) : HResult; stdcall;
begin
	result := idd^^.GetGroupOwner(idd, idGroup, idOwner);
end;

function IDirectPlay4_SetGroupOwner(idd : IDirectPlay4AW; idGroup : TDPID; idOwner : TDPID) : HResult; stdcall;
begin
	result := idd^^.SetGroupOwner(idd, idGroup, idOwner);
end;

function IDirectPlay4_SendEx(idd : IDirectPlay4AW; idFrom : TDPID; idTo : TDPID; dwFlags : DWORD; lpData : Pointer; dwDataSize : DWORD; dwPriority : DWORD; dwTimeout : DWORD; lpContext : Pointer; lpdwMsgId : PDWORD) : HResult; stdcall;
begin
	result := idd^^.SendEx(idd, idFrom, idTo, dwFlags, lpData, dwDataSize, dwPriority, dwTimeout, lpContext, lpdwMsgId);
end;

function IDirectPlay4_GetMessageQueue(idd : IDirectPlay4AW; idFrom : TDPID; idTo : TDPID; dwFlags : DWORD; lpdwNumMsgs : PDWORD; lpdwNumBytes : PDWORD) : HResult; stdcall;
begin
	result := idd^^.GetMessageQueue(idd, idFrom, idTo, dwFlags, lpdwNumMsgs, lpdwNumBytes);
end;

function IDirectPlay4_CancelMessage(idd : IDirectPlay4AW; dwMessageID : DWORD; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.CancelMessage(idd, dwMessageID, dwFlags);
end;

function IDirectPlay4_CancelPriority(idd : IDirectPlay4AW; dwMinPriority : DWORD; dwMaxPriority : DWORD; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.CancelPriority(idd, dwMinPriority, dwMaxPriority, dwFlags);
end;


// IDirectPlay4W interface methods


// IDirectPlay4A interface methods


// IDirectPlay interface methods

function IDirectPlay_QueryInterface(idd : IDirectPlay; const IID : TGUID; var obj) : HRESULT; stdcall;
begin
	result := idd^^.QueryInterface(idd, IID, obj);
end;

function IDirectPlay_AddRef(idd : IDirectPlay) : Longint; stdcall;
begin
	result := idd^^.AddRef(idd);
end;

function IDirectPlay_Release(idd : IDirectPlay) : Longint; stdcall;
begin
	result := idd^^.Release(idd);
end;

function IDirectPlay_AddPlayerToGroup(idd : IDirectPlay; pidGroup : TDPID; pidPlayer : TDPID) : HResult; stdcall;
begin
	result := idd^^.AddPlayerToGroup(idd, pidGroup, pidPlayer);
end;

function IDirectPlay_Close(idd : IDirectPlay) : HResult; stdcall;
begin
	result := idd^^.Close(idd);
end;

function IDirectPlay_CreatePlayer(idd : IDirectPlay; var lppidID : TDPID; lpPlayerFriendlyName : PChar; lpPlayerFormalName : PChar; lpEvent : PHandle) : HResult; stdcall;
begin
	result := idd^^.CreatePlayer(idd, lppidID, lpPlayerFriendlyName, lpPlayerFormalName, lpEvent);
end;

function IDirectPlay_CreateGroup(idd : IDirectPlay; var lppidID : TDPID; lpGroupFriendlyName : PChar; lpGroupFormalName : PChar) : HResult; stdcall;
begin
	result := idd^^.CreateGroup(idd, lppidID, lpGroupFriendlyName, lpGroupFormalName);
end;

function IDirectPlay_DeletePlayerFromGroup(idd : IDirectPlay; pidGroup : TDPID; pidPlayer : TDPID) : HResult; stdcall;
begin
	result := idd^^.DeletePlayerFromGroup(idd, pidGroup, pidPlayer);
end;

function IDirectPlay_DestroyPlayer(idd : IDirectPlay; pidID : TDPID) : HResult; stdcall;
begin
	result := idd^^.DestroyPlayer(idd, pidID);
end;

function IDirectPlay_DestroyGroup(idd : IDirectPlay; pidID : TDPID) : HResult; stdcall;
begin
	result := idd^^.DestroyGroup(idd, pidID);
end;

function IDirectPlay_EnableNewPlayers(idd : IDirectPlay; bEnable : BOOL) : HResult; stdcall;
begin
	result := idd^^.EnableNewPlayers(idd, bEnable);
end;

function IDirectPlay_EnumGroupPlayers(idd : IDirectPlay; pidGroupPID : TDPID; lpEnumPlayersCallback : TDPEnumPlayersCallback; lpContext : Pointer; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.EnumGroupPlayers(idd, pidGroupPID, @lpEnumPlayersCallback, lpContext, dwFlags);
end;

function IDirectPlay_EnumGroups(idd : IDirectPlay; dwSessionID : DWORD; lpEnumPlayersCallback : TDPEnumPlayersCallback; lpContext : Pointer; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.EnumGroups(idd, dwSessionID, @lpEnumPlayersCallback, lpContext, dwFlags);
end;

function IDirectPlay_EnumPlayers(idd : IDirectPlay; dwSessionId : DWORD; lpEnumPlayersCallback : TDPEnumPlayersCallback; lpContext : Pointer; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.EnumPlayers(idd, dwSessionId, @lpEnumPlayersCallback, lpContext, dwFlags);
end;

function IDirectPlay_EnumSessions(idd : IDirectPlay; var lpSDesc : TDPSessionDesc; dwTimeout : DWORD; lpEnumSessionsCallback : TDPEnumSessionsCallback; lpContext : Pointer; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.EnumSessions(idd, lpSDesc, dwTimeout, @lpEnumSessionsCallback, lpContext, dwFlags);
end;

function IDirectPlay_GetCaps(idd : IDirectPlay; var lpDPCaps : TDPCaps) : HResult; stdcall;
begin
	result := idd^^.GetCaps(idd, lpDPCaps);
end;

function IDirectPlay_GetMessageCount(idd : IDirectPlay; pidID : TDPID; var lpdwCount : DWORD) : HResult; stdcall;
begin
	result := idd^^.GetMessageCount(idd, pidID, lpdwCount);
end;

function IDirectPlay_GetPlayerCaps(idd : IDirectPlay; pidID : TDPID; var lpDPPlayerCaps : TDPCaps) : HResult; stdcall;
begin
	result := idd^^.GetPlayerCaps(idd, pidID, lpDPPlayerCaps);
end;

function IDirectPlay_GetPlayerName(idd : IDirectPlay; pidID : TDPID; lpPlayerFriendlyName : PChar; var lpdwFriendlyNameLength : DWORD; lpPlayerFormalName : PChar; var lpdwFormalNameLength : DWORD) : HResult; stdcall;
begin
	result := idd^^.GetPlayerName(idd, pidID, lpPlayerFriendlyName, lpdwFriendlyNameLength, lpPlayerFormalName, lpdwFormalNameLength);
end;

function IDirectPlay_Initialize(idd : IDirectPlay; const lpGUID : TGUID) : HResult; stdcall;
begin
	result := idd^^.Initialize(idd, lpGUID);
end;

function IDirectPlay_Open(idd : IDirectPlay; var lpSDesc : TDPSessionDesc) : HResult; stdcall;
begin
	result := idd^^.Open(idd, lpSDesc);
end;

function IDirectPlay_Receive(idd : IDirectPlay; var lppidFrom , lppidTo : TDPID; dwFlags : DWORD; var lpvBuffer; var lpdwSize : DWORD) : HResult; stdcall;
begin
	result := idd^^.Receive(idd, lppidFrom, lppidTo, dwFlags, lpvBuffer, lpdwSize);
end;

function IDirectPlay_SaveSession(idd : IDirectPlay; lpSessionName : PChar) : HResult; stdcall;
begin
	result := idd^^.SaveSession(idd, lpSessionName);
end;

function IDirectPlay_Send(idd : IDirectPlay; pidFrom : TDPID; pidTo : TDPID; dwFlags : DWORD; var lpvBuffer; dwBuffSize : DWORD) : HResult; stdcall;
begin
	result := idd^^.Send(idd, pidFrom, pidTo, dwFlags, lpvBuffer, dwBuffSize);
end;

function IDirectPlay_SetPlayerName(idd : IDirectPlay; pidID : TDPID; lpPlayerFriendlyName : PChar; lpPlayerFormalName : PChar) : HResult; stdcall;
begin
	result := idd^^.SetPlayerName(idd, pidID, lpPlayerFriendlyName, lpPlayerFormalName);
end;


// IDirectPlayLobbyAW interface methods

function IDirectPlayLobby_AddRef(idd : IDirectPlayLobbyAW) : Longint; stdcall;
begin
	result := idd^^.AddRef(idd);
end;

function IDirectPlayLobby_Release(idd : IDirectPlayLobbyAW) : Longint; stdcall;
begin
	result := idd^^.Release(idd);
end;

function IDirectPlayLobby_Connect(idd : IDirectPlayLobbyAW; dwFlags : DWORD; var lplpDP : IDirectPlay2; pUnk : IUnknown) : HResult; stdcall;
begin
	result := idd^^.Connect(idd, dwFlags, lplpDP, pUnk);
end;

function IDirectPlayLobby_CreateAddress(idd : IDirectPlayLobbyAW; const guidSP , guidDataType : TGUID; var lpData; dwDataSize : DWORD; var lpAddress; var lpdwAddressSize : DWORD) : HResult; stdcall;
begin
	result := idd^^.CreateAddress(idd, guidSP, guidDataType, lpData, dwDataSize, lpAddress, lpdwAddressSize);
end;

function IDirectPlayLobby_EnumAddress(idd : IDirectPlayLobbyAW; lpEnumAddressCallback : TDPEnumAdressCallback; var lpAddress; dwAddressSize : DWORD; lpContext : Pointer) : HResult; stdcall;
begin
	result := idd^^.EnumAddress(idd, @lpEnumAddressCallback, lpAddress, dwAddressSize, lpContext);
end;

function IDirectPlayLobby_EnumAddressTypes(idd : IDirectPlayLobbyAW; lpEnumAddressTypeCallback : TDPLEnumAddressTypesCallback; const guidSP : TGUID; lpContext : Pointer; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.EnumAddressTypes(idd, @lpEnumAddressTypeCallback, guidSP, lpContext, dwFlags);
end;

function IDirectPlayLobby_EnumLocalApplications(idd : IDirectPlayLobbyAW; lpEnumLocalAppCallback : TDPLEnumLocalApplicationsCallback; lpContext : Pointer; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.EnumLocalApplications(idd, @lpEnumLocalAppCallback, lpContext, dwFlags);
end;

function IDirectPlayLobby_GetConnectionSettings(idd : IDirectPlayLobbyAW; dwAppID : DWORD; lpData : PDPLConnection; var lpdwDataSize : DWORD) : HResult; stdcall;
begin
	result := idd^^.GetConnectionSettings(idd, dwAppID, lpData, lpdwDataSize);
end;

function IDirectPlayLobby_ReceiveLobbyMessage(idd : IDirectPlayLobbyAW; dwFlags : DWORD; dwAppID : DWORD; var lpdwMessageFlags : DWORD; lpData : Pointer; var lpdwDataSize : DWORD) : HResult; stdcall;
begin
	result := idd^^.ReceiveLobbyMessage(idd, dwFlags, dwAppID, lpdwMessageFlags, lpData, lpdwDataSize);
end;

function IDirectPlayLobby_RunApplication(idd : IDirectPlayLobbyAW; dwFlags : DWORD; var lpdwAppId : DWORD; const lpConn : TDPLConnection; hReceiveEvent : THandle) : HResult; stdcall;
begin
	result := idd^^.RunApplication(idd, dwFlags, lpdwAppId, lpConn, hReceiveEvent);
end;

function IDirectPlayLobby_SendLobbyMessage(idd : IDirectPlayLobbyAW; dwFlags : DWORD; dwAppID : DWORD; const lpData; dwDataSize : DWORD) : HResult; stdcall;
begin
	result := idd^^.SendLobbyMessage(idd, dwFlags, dwAppID, lpData, dwDataSize);
end;

function IDirectPlayLobby_SetConnectionSettings(idd : IDirectPlayLobbyAW; dwFlags : DWORD; dwAppID : DWORD; var lpConn : TDPLConnection) : HResult; stdcall;
begin
	result := idd^^.SetConnectionSettings(idd, dwFlags, dwAppID, lpConn);
end;

function IDirectPlayLobby_SetLobbyMessageEvent(idd : IDirectPlayLobbyAW; dwFlags : DWORD; dwAppID : DWORD; hReceiveEvent : THandle) : HResult; stdcall;
begin
	result := idd^^.SetLobbyMessageEvent(idd, dwFlags, dwAppID, hReceiveEvent);
end;


// IDirectPlayLobbyW interface methods


// IDirectPlayLobbyA interface methods


// IDirectPlayLobby2AW interface methods

function IDirectPlayLobby2_AddRef(idd : IDirectPlayLobby2AW) : Longint; stdcall;
begin
	result := idd^^.AddRef(idd);
end;

function IDirectPlayLobby2_Release(idd : IDirectPlayLobby2AW) : Longint; stdcall;
begin
	result := idd^^.Release(idd);
end;

function IDirectPlayLobby2_Connect(idd : IDirectPlayLobby2AW; dwFlags : DWORD; var lplpDP : IDirectPlay2; pUnk : IUnknown) : HResult; stdcall;
begin
	result := idd^^.Connect(idd, dwFlags, lplpDP, pUnk);
end;

function IDirectPlayLobby2_CreateAddress(idd : IDirectPlayLobby2AW; const guidSP , guidDataType : TGUID; var lpData; dwDataSize : DWORD; var lpAddress; var lpdwAddressSize : DWORD) : HResult; stdcall;
begin
	result := idd^^.CreateAddress(idd, guidSP, guidDataType, lpData, dwDataSize, lpAddress, lpdwAddressSize);
end;

function IDirectPlayLobby2_EnumAddress(idd : IDirectPlayLobby2AW; lpEnumAddressCallback : TDPEnumAdressCallback; var lpAddress; dwAddressSize : DWORD; lpContext : Pointer) : HResult; stdcall;
begin
	result := idd^^.EnumAddress(idd, @lpEnumAddressCallback, lpAddress, dwAddressSize, lpContext);
end;

function IDirectPlayLobby2_EnumAddressTypes(idd : IDirectPlayLobby2AW; lpEnumAddressTypeCallback : TDPLEnumAddressTypesCallback; const guidSP : TGUID; lpContext : Pointer; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.EnumAddressTypes(idd, @lpEnumAddressTypeCallback, guidSP, lpContext, dwFlags);
end;

function IDirectPlayLobby2_EnumLocalApplications(idd : IDirectPlayLobby2AW; lpEnumLocalAppCallback : TDPLEnumLocalApplicationsCallback; lpContext : Pointer; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.EnumLocalApplications(idd, @lpEnumLocalAppCallback, lpContext, dwFlags);
end;

function IDirectPlayLobby2_GetConnectionSettings(idd : IDirectPlayLobby2AW; dwAppID : DWORD; lpData : PDPLConnection; var lpdwDataSize : DWORD) : HResult; stdcall;
begin
	result := idd^^.GetConnectionSettings(idd, dwAppID, lpData, lpdwDataSize);
end;

function IDirectPlayLobby2_ReceiveLobbyMessage(idd : IDirectPlayLobby2AW; dwFlags : DWORD; dwAppID : DWORD; var lpdwMessageFlags : DWORD; lpData : Pointer; var lpdwDataSize : DWORD) : HResult; stdcall;
begin
	result := idd^^.ReceiveLobbyMessage(idd, dwFlags, dwAppID, lpdwMessageFlags, lpData, lpdwDataSize);
end;

function IDirectPlayLobby2_RunApplication(idd : IDirectPlayLobby2AW; dwFlags : DWORD; var lpdwAppId : DWORD; const lpConn : TDPLConnection; hReceiveEvent : THandle) : HResult; stdcall;
begin
	result := idd^^.RunApplication(idd, dwFlags, lpdwAppId, lpConn, hReceiveEvent);
end;

function IDirectPlayLobby2_SendLobbyMessage(idd : IDirectPlayLobby2AW; dwFlags : DWORD; dwAppID : DWORD; const lpData; dwDataSize : DWORD) : HResult; stdcall;
begin
	result := idd^^.SendLobbyMessage(idd, dwFlags, dwAppID, lpData, dwDataSize);
end;

function IDirectPlayLobby2_SetConnectionSettings(idd : IDirectPlayLobby2AW; dwFlags : DWORD; dwAppID : DWORD; var lpConn : TDPLConnection) : HResult; stdcall;
begin
	result := idd^^.SetConnectionSettings(idd, dwFlags, dwAppID, lpConn);
end;

function IDirectPlayLobby2_SetLobbyMessageEvent(idd : IDirectPlayLobby2AW; dwFlags : DWORD; dwAppID : DWORD; hReceiveEvent : THandle) : HResult; stdcall;
begin
	result := idd^^.SetLobbyMessageEvent(idd, dwFlags, dwAppID, hReceiveEvent);
end;

function IDirectPlayLobby2_CreateCompoundAddress(idd : IDirectPlayLobby2AW; const lpElements : TDPCompoundAddressElement; dwElementCount : DWORD; lpAddress : Pointer; var lpdwAddressSize : DWORD) : HResult; stdcall;
begin
	result := idd^^.CreateCompoundAddress(idd, lpElements, dwElementCount, lpAddress, lpdwAddressSize);
end;


// IDirectPlayLobby2W interface methods


// IDirectPlayLobby2A interface methods


// IDirectPlayLobby3AW interface methods

function IDirectPlayLobby3_AddRef(idd : IDirectPlayLobby3AW) : Longint; stdcall;
begin
	result := idd^^.AddRef(idd);
end;

function IDirectPlayLobby3_Release(idd : IDirectPlayLobby3AW) : Longint; stdcall;
begin
	result := idd^^.Release(idd);
end;

function IDirectPlayLobby3_Connect(idd : IDirectPlayLobby3AW; dwFlags : DWORD; var lplpDP : IDirectPlay2; pUnk : IUnknown) : HResult; stdcall;
begin
	result := idd^^.Connect(idd, dwFlags, lplpDP, pUnk);
end;

function IDirectPlayLobby3_CreateAddress(idd : IDirectPlayLobby3AW; const guidSP , guidDataType : TGUID; var lpData; dwDataSize : DWORD; var lpAddress; var lpdwAddressSize : DWORD) : HResult; stdcall;
begin
	result := idd^^.CreateAddress(idd, guidSP, guidDataType, lpData, dwDataSize, lpAddress, lpdwAddressSize);
end;

function IDirectPlayLobby3_EnumAddress(idd : IDirectPlayLobby3AW; lpEnumAddressCallback : TDPEnumAdressCallback; var lpAddress; dwAddressSize : DWORD; lpContext : Pointer) : HResult; stdcall;
begin
	result := idd^^.EnumAddress(idd, @lpEnumAddressCallback, lpAddress, dwAddressSize, lpContext);
end;

function IDirectPlayLobby3_EnumAddressTypes(idd : IDirectPlayLobby3AW; lpEnumAddressTypeCallback : TDPLEnumAddressTypesCallback; const guidSP : TGUID; lpContext : Pointer; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.EnumAddressTypes(idd, @lpEnumAddressTypeCallback, guidSP, lpContext, dwFlags);
end;

function IDirectPlayLobby3_EnumLocalApplications(idd : IDirectPlayLobby3AW; lpEnumLocalAppCallback : TDPLEnumLocalApplicationsCallback; lpContext : Pointer; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.EnumLocalApplications(idd, @lpEnumLocalAppCallback, lpContext, dwFlags);
end;

function IDirectPlayLobby3_GetConnectionSettings(idd : IDirectPlayLobby3AW; dwAppID : DWORD; lpData : PDPLConnection; var lpdwDataSize : DWORD) : HResult; stdcall;
begin
	result := idd^^.GetConnectionSettings(idd, dwAppID, lpData, lpdwDataSize);
end;

function IDirectPlayLobby3_ReceiveLobbyMessage(idd : IDirectPlayLobby3AW; dwFlags : DWORD; dwAppID : DWORD; var lpdwMessageFlags : DWORD; lpData : Pointer; var lpdwDataSize : DWORD) : HResult; stdcall;
begin
	result := idd^^.ReceiveLobbyMessage(idd, dwFlags, dwAppID, lpdwMessageFlags, lpData, lpdwDataSize);
end;

function IDirectPlayLobby3_RunApplication(idd : IDirectPlayLobby3AW; dwFlags : DWORD; var lpdwAppId : DWORD; const lpConn : TDPLConnection; hReceiveEvent : THandle) : HResult; stdcall;
begin
	result := idd^^.RunApplication(idd, dwFlags, lpdwAppId, lpConn, hReceiveEvent);
end;

function IDirectPlayLobby3_SendLobbyMessage(idd : IDirectPlayLobby3AW; dwFlags : DWORD; dwAppID : DWORD; const lpData; dwDataSize : DWORD) : HResult; stdcall;
begin
	result := idd^^.SendLobbyMessage(idd, dwFlags, dwAppID, lpData, dwDataSize);
end;

function IDirectPlayLobby3_SetConnectionSettings(idd : IDirectPlayLobby3AW; dwFlags : DWORD; dwAppID : DWORD; var lpConn : TDPLConnection) : HResult; stdcall;
begin
	result := idd^^.SetConnectionSettings(idd, dwFlags, dwAppID, lpConn);
end;

function IDirectPlayLobby3_SetLobbyMessageEvent(idd : IDirectPlayLobby3AW; dwFlags : DWORD; dwAppID : DWORD; hReceiveEvent : THandle) : HResult; stdcall;
begin
	result := idd^^.SetLobbyMessageEvent(idd, dwFlags, dwAppID, hReceiveEvent);
end;

function IDirectPlayLobby3_CreateCompoundAddress(idd : IDirectPlayLobby3AW; const lpElements : TDPCompoundAddressElement; dwElementCount : DWORD; lpAddress : Pointer; var lpdwAddressSize : DWORD) : HResult; stdcall;
begin
	result := idd^^.CreateCompoundAddress(idd, lpElements, dwElementCount, lpAddress, lpdwAddressSize);
end;

function IDirectPlayLobby3_ConnectEx(idd : IDirectPlayLobby3AW; dwFlags : DWORD; const riid : TGUID; var lplpDP; pUnk : IUnknown) : HResult; stdcall;
begin
	result := idd^^.ConnectEx(idd, dwFlags, riid, lplpDP, pUnk);
end;

function IDirectPlayLobby3_RegisterApplication(idd : IDirectPlayLobby3AW; dwFlags : DWORD; var lpAppDesc : TDPApplicationDesc) : HResult; stdcall;
begin
	result := idd^^.RegisterApplication(idd, dwFlags, lpAppDesc);
end;

function IDirectPlayLobby3_UnregisterApplication(idd : IDirectPlayLobby3AW; dwFlags : DWORD; const guidApplication : TGUID) : HResult; stdcall;
begin
	result := idd^^.UnregisterApplication(idd, dwFlags, guidApplication);
end;

function IDirectPlayLobby3_WaitForConnectionSettings(idd : IDirectPlayLobby3AW; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.WaitForConnectionSettings(idd, dwFlags);
end;


// IDirectPlayLobby3W interface methods


// IDirectPlayLobby3A interface methods


begin
end.
