{
    This file is a part of the graphics library GraphiX
    Copyright (C) 2001 Michael Knapp

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
}

{============================================================================}
{ ARK Logic 1000PV, 2000Pv, 2000MT, 2000MI                                   }
{============================================================================}
{$I gxglobal.cfg}
UNIT gxhw_ark;

INTERFACE

USES gxbase,gxpci,gx3dtype,gxsup,gxmem;
{$I gxlocal.cfg}

PROCEDURE sethwaprocs_ark(col:longint);
{PROCEDURE setupdevice_ark(baseaddr:dword;var pcidev:TPCIdevice);
PROCEDURE adjustaddresses_ark(old_ds_base,new_ds_base:dword); }
PROCEDURE setreslist_ark(var modelist:PModeEntry);
FUNCTION detectchip_ark(var chipid:dword;var name:string):longint;
FUNCTION detectmem_ark:longint;
PROCEDURE enableregs_ark;
PROCEDURE disableregs_ark;
PROCEDURE setcolormode_ark(col:longint);
PROCEDURE scanline_ark(linewidth:word);
PROCEDURE displaystart_ark(offs:dword);
PROCEDURE bankswitch_ark;
PROCEDURE enableLFB_ark(physaddr:dword);
PROCEDURE enableLFB_ark_pci(physaddr:dword);
PROCEDURE disableLFB_ark;

PROCEDURE enableHWA_ark(col,init,bpl,bpp,pix:longint);
PROCEDURE disableHWA_ark;
PROCEDURE graphwinhw_ark(x1,y1,x2,y2:longint);
{PROCEDURE setpattern_ark;
PROCEDURE line_ark(x1,y1,x2,y2,f:longint);
PROCEDURE line16_ark(x1,y1,x2,y2,f:longint);
PROCEDURE line32_ark(x1,y1,x2,y2,f:longint);
PROCEDURE lineH8_ark(x1,x2,y,f:longint);
PROCEDURE lineH16_ark(x1,x2,y,f:longint);
PROCEDURE lineH32_ark(x1,x2,y,f:longint);
PROCEDURE lineH8_pattern_ark(x1,x2,y,f:longint);
PROCEDURE lineH16_pattern_ark(x1,x2,y,f:longint);
PROCEDURE lineH32_pattern_ark(x1,x2,y,f:longint); }
{PROCEDURE bar_ark(x1,y1,x2,y2,f:longint);}
{PROCEDURE bar8_ark(x1,y1,x2,y2,f:longint);
PROCEDURE bar16_ark(x1,y1,x2,y2,f:longint);
PROCEDURE bar32_ark(x1,y1,x2,y2,f:longint);
PROCEDURE bar8_pattern_ark(x1,y1,x2,y2,f:longint);
PROCEDURE bar16_pattern_ark(x1,y1,x2,y2,f:longint);
PROCEDURE bar32_pattern_ark(x1,y1,x2,y2,f:longint);
PROCEDURE barXOR8_ark(x1,y1,x2,y2,f:longint);
PROCEDURE barXOR16_ark(x1,y1,x2,y2,f:longint);
PROCEDURE barXOR32_ark(x1,y1,x2,y2,f:longint);
PROCEDURE barXOR8_pattern_ark(x1,y1,x2,y2,f:longint);
PROCEDURE barXOR16_pattern_ark(x1,y1,x2,y2,f:longint);
PROCEDURE barXOR32_pattern_ark(x1,y1,x2,y2,f:longint);
PROCEDURE moverect_ark(x1,y1,x2,y2,x,y:longint);}

IMPLEMENTATION

USES gxcrtext,graphix,gxtype;

{VAR mmiomap0:tmmiomap;
    mmiomap1:tmmiomap;
    option,devid:longint;}

{PROCEDURE setupdevice_ark(baseaddr:dword;var pcidev:TPCIdevice);
BEGIN
END;

PROCEDURE adjustaddresses_ark(old_ds_base,new_ds_base:dword);
BEGIN
  adjustaddress(lfbbase,old_ds_base,new_ds_base);
END;}

{----------------------------------------------------------------------------}

FUNCTION detectchip_ark(var chipid:dword;var name:string):longint;
VAR save1,save2,chip:byte;
BEGIN
  ASM
    MOV DX,03C4h
    MOV AL,1Dh
    OUT DX,AL
    INC DX
    IN AL,DX
    MOV save1,AL
    MOV AL,0
    OUT DX,AL {lock extended regs}
    DEC DX

    MOV AL,11h  { test all bits if write/readable }
    OUT DX,AL
    INC DX
    IN AL,DX
    MOV save2,AL
    MOV AL,0FFh
    OUT DX,AL
    IN AL,DX
    CMP AL,0FFh
    JE @ark_noark
    MOV AL,0h
    OUT DX,AL
    IN AL,DX
    MOV BL,AL
    MOV AL,save2
    OUT DX,AL
    DEC DX
    CMP BL,0
    JE @ark_noark
  
    MOV AL,12h  { test all bits if write/readable }
    OUT DX,AL
    INC DX
    IN AL,DX
    MOV save2,AL
    MOV AL,0FFh
    OUT DX,AL
    IN AL,DX
    CMP AL,0FFh
    JE @ark_noark
    MOV AL,0h
    OUT DX,AL
    IN AL,DX
    MOV BL,AL
    MOV AL,save2
    OUT DX,AL
    DEC DX
    CMP BL,0
    JE @ark_noark

    MOV AL,1Dh
    MOV AH,save1
    OUT DX,AX  {unlock extended regs}
  
    MOV AL,11h  { test all bits if write/readable}
    OUT DX,AL
    INC DX
    IN AL,DX
    MOV save2,AL
    MOV AL,0FFh
    OUT DX,AL
    IN AL,DX
    CMP AL,0FFh
    JNE @ark_noark
    MOV AL,0h
    OUT DX,AL
    IN AL,DX
    MOV BL,AL
    MOV AL,save2
    OUT DX,AL
    DEC DX
    CMP BL,0
    JNE @ark_noark
  
    MOV AL,12h  { test all bits if write/readable }
    OUT DX,AL
    INC DX
    IN AL,DX
    MOV save2,AL
    MOV AL,0FFh
    OUT DX,AL
    IN AL,DX
    CMP AL,0FFh
    JNE @ark_noark
    MOV AL,0h
    OUT DX,AL
    IN AL,DX
    MOV BL,AL
    MOV AL,save2
    OUT DX,AL
    DEC DX
    CMP BL,0
    JNE @ark_noark
    MOV DX,03D4h
    MOV AL,50h
    OUT DX,AL
    INC DX
    IN AL,DX
    JMP @ende
  @ark_noark:
    MOV AL,1Dh
    MOV AH,save1
    OUT DX,AX  {unlock extended regs}
    XOR AL,AL
  @ende:
    AND AL,0F8h
    MOV chip,AL
  END;
  CASE chip OF
    $00:;
    $88:name:='ARK1000VL';
    $90:name:='ARK1000PV';
    $98:name:='ARK2000PV';
    $A0:name:='ARK2000MT';
    $A8:name:='ARK2000MI';
    ELSE name:='ARK - unknown - ID '+hexbyte(chip);
  END;
  chipid:=chip;
  detectchip_ark:=chip;
END;

FUNCTION detectmem_ark:longint;assembler;
ASM
  MOV DX,03C4h
  MOV AL,10h
  OUT DX,AL
  INC DX
  IN AL,DX
  MOV CL,AL
  SHR CL,6
  MOV EAX,1024
  SHL EAX,CL
END;

{----------------------------------------------------------------------------}

PROCEDURE enableregs_ark;assembler;
ASM
  MOV DX,03C4h
  MOV AL,1Dh
  OUT DX,AL
  INC DX
  IN AL,DX
  OR AL,01h
  OUT DX,AL

  DEC DX
  MOV AL,10h
  OUT DX,AL
  INC DX
  IN AL,DX
  OR AL,03h
  OUT DX,AL
END;

PROCEDURE disableregs_ark;assembler;
ASM
  MOV DX,03C4h
  MOV AL,10h
  OUT DX,AL
  INC DX
  IN AL,DX
  AND AL,0E0h
  OUT DX,AL

  MOV DX,03C4h
  MOV AL,1Dh
  OUT DX,AL
  INC DX
  IN AL,DX
  AND AL,0FEh
  OUT DX,AL
END;

PROCEDURE setcolormode_ark(col:longint);assembler;
ASM
  MOV BX,0
  CMP col,ig_col8
  JNE @scm_w1
  MOV BX,0004h
  JMP @scm_w5
@scm_w1:
  CMP col,ig_col15
  JNE @scm_w2
  MOV BX,0008h
  JMP @scm_w5
@scm_w2:
  CMP col,ig_col16
  JNE @scm_w3
  MOV BX,0008h
  JMP @scm_w5
@scm_w3:
  CMP col,ig_col24
  JNE @scm_w4
  MOV BX,000Ch
  JMP @scm_w5
@scm_w4:
  CMP col,ig_col32
  JNE @scm_w5
  MOV BX,000Ch
  JMP @scm_w5
@scm_w5:

  MOV DX,03C4h
  MOV AL,11h
  OUT DX,AL
  INC DX
  IN AL,DX
  AND AL,0F3h
  OR AL,BL
  OUT DX,AL
END;

PROCEDURE scanline_ark(linewidth:word);assembler;
ASM
{bit 0-7}
  MOV DX,03D4h
  MOV AH,BYTE PTR linewidth
  MOV AL,13h
  OUT DX,AX
{bit 8}
  MOV AX,linewidth
  SHL AH,3
  AND AH,08h
  MOV AL,41h
  OUT DX,AL
  INC DX
  IN AL,DX
  AND AL,0F7h
  OR AL,AH
  OUT DX,AL
END;

PROCEDURE displaystart_ark(offs:dword);assembler;
ASM
  MOV EBX,offs
{bit 0-7}
  SHR EBX,2
  MOV DX,03D4h
  MOV AH,BL
  MOV AL,0Dh
  OUT DX,AX
{bit 8-15}
  SHR EBX,8
  MOV DX,03D4h
  MOV AH,BL
  MOV AL,0Ch
  OUT DX,AX
{bit 16-18}
  SHR EBX,8
  MOV AH,BL
  AND AH,07h
  MOV AL,40h
  OUT DX,AL
  INC DX
  IN AL,DX
  AND AL,0F8h
  OR AL,AH
  OUT DX,AL
  DEC DX
{bit 19}
  SHR EBX,3
  MOV AH,BL
  AND AH,01h
  MOV AL,41h
  OUT DX,AL
  INC DX
  IN AL,DX
  AND AL,0FEh
  OR AL,AH
  OUT DX,AL
END;

PROCEDURE bankswitch_ark;assembler;
ASM
  MOV AH,DL
  MOV AL,15h
  MOV DX,03C4h
  OUT DX,AX
  INC AL
  OUT DX,AX
END;

PROCEDURE enableLFB_ark(physaddr:dword);assembler;
ASM
  MOV DX,03C4h
  MOV AL,10h
  OUT DX,AL
  INC DX
  IN AL,DX
  AND AL,0EFh
  OUT DX,AL

  MOV DX,03C4h
  MOV AL,12h
  OUT DX,AL
  INC DX
  IN AL,DX
  AND AL,0FCh
  OR AL,02h
  OUT DX,AL

  MOV EBX,physaddr
  SHR EBX,16
  MOV DX,03C4h
  MOV AL,13h
  MOV AH,BL
  OUT DX,AX
  MOV AL,14h
  MOV AH,BH
  OUT DX,AX

  MOV DX,03C4h
  MOV AL,10h
  OUT DX,AL
  INC DX
  IN AL,DX
  OR AL,1Ch
  OUT DX,AL
END;

PROCEDURE enableLFB_ark_pci(physaddr:dword);assembler;
ASM
  MOV DX,03C4h
  MOV AL,10h
  OUT DX,AL
  INC DX
  IN AL,DX
  AND AL,0EFh
  OUT DX,AL

  MOV DX,03C4h
  MOV AL,12h
  OUT DX,AL
  INC DX
  IN AL,DX
  AND AL,0FCh
  OR AL,02h
  OUT DX,AL

  MOV DX,03C4h
  MOV AL,10h
  OUT DX,AL
  INC DX
  IN AL,DX
  OR AL,1Ch
  OUT DX,AL
END;

PROCEDURE disableLFB_ark;assembler;
ASM
  MOV DX,03C4h
  MOV AL,10h
  OUT DX,AL
  INC DX
  IN AL,DX
  AND AL,0EFh
  OUT DX,AL
END;

{------------------------------- Hardware-Acceleration ----------------------}

PROCEDURE enableHWA_ark(col,init,bpl,bpp,pix:longint);
VAR COPpixelsize,FrameBufferPitch:byte;
BEGIN
  CASE bpp OF
    1:COPpixelsize:=$04;
    2:COPpixelsize:=$08;
    4:COPpixelsize:=$0C;
  END;
  CASE (bpl DIV bpp) OF
    640:FrameBufferPitch:=$0;
    800:FrameBufferPitch:=$1;
    1024:FrameBufferPitch:=$2;
    1280:FrameBufferPitch:=$4;
    1600:FrameBufferPitch:=$5;
    2048:FrameBufferPitch:=$6;
  END;
  ASM
    MOV DX,03C4h
    MOV AL,11h
    OUT DX,AL
    INC DX
    IN AL,DX
    AND AL,0F3h
    OR AL,COPpixelsize
    OUT DX,AL
    MOV DX,03C4h
    MOV AL,17h
    OUT DX,AL
    INC DX
    IN AL,DX
    AND AL,0F8h
    OR AL,FrameBufferPitch
    OUT DX,AL

    MOV EDI,mmiooffs
    MOV WORD PTR [EDI+1Ah],0FFFFh
    MOV WORD PTR [EDI+1Eh],0FFFFh
  END;
END;

PROCEDURE disableHWA_ark;
BEGIN
END;

PROCEDURE graphwinhw_ark(x1,y1,x2,y2:longint);assembler;
ASM
  MOV EDI,mmiooffs
  MOV EAX,x1
  MOV [EDI+58h],AX
  MOV EAX,y1
  ADD EAX,frontdrawoffsety
  MOV [EDI+5Ah],AX
  MOV EAX,x2
  MOV [EDI+5Ch],AX
  MOV EAX,y2
  ADD EAX,frontdrawoffsety
  MOV [EDI+5Eh],AX
END;

PROCEDURE setpatternHW_ark(pattern:ppattern);assembler;
ASM
END;

{PROCEDURE setpattern_ark;assembler;
ASM
END;}

{----------------------------- line ---------------------------------------}
{
PROCEDURE line8_ark(x1,y1,x2,y2,f:longint);assembler;
ASM
  MOV EDI,mmiooffs


  MOV WORD PTR [EDI+18h],0305h
  MOV EAX,f
  MOV [EDI+02h],AX
  SHR EAX,16
  MOV [EDI+06h],AX




  MOV AX,WORD PTR y1
  SHL EAX,16
  MOV AX,WORD PTR x1
  MOV [EDI+1C40h],EAX
  MOV AX,WORD PTR y2
  SHL EAX,16
  MOV AX,WORD PTR x2
  MOV [EDI+1C44h],EAX
  MOV AL,BYTE PTR f
  MOV AH,AL
  SHL EAX,8
  MOV AL,AH
  SHL EAX,8
  MOV AL,AH
  MOV [EDI+1C24h],EAX
  MOV DWORD PTR [EDI+1D00h],040C4803h
@line8_ark_busy:
  TEST DWORD PTR [EDI+1E14h],00010000h
  JNZ @line8_ark_busy
END;

PROCEDURE line16_ark(x1,y1,x2,y2,f:longint);assembler;
ASM
END;

PROCEDURE line32_ark(x1,y1,x2,y2,f:longint);assembler;
ASM
END;
}
{-------------------------------- lineH -------------------------------------}

PROCEDURE lineh_ark(x1,x2,y,f:longint);assembler;
ASM
  MOV EDI,mmiooffs
  MOV WORD PTR [EDI+18h],0305h
  MOV EAX,f
  MOV [EDI+02h],AX
  SHR EAX,16
  MOV [EDI+06h],AX

  MOV EAX,x1
  MOV EBX,x2
  CMP EAX,EBX
  JLE @lineh_ark_w1
  XCHG EBX,EAX
@lineh_ark_w1:
  MOV [EDI+70h],AX
  SUB EBX,EAX
  MOV [EDI+74h],BX

  MOV EAX,y
  ADD EAX,frontdrawoffsety
  MOV [EDI+72h],AX
  MOV WORD PTR [EDI+76h],0000h

  MOV WORD PTR [EDI+7Ch],0000h
  MOV WORD PTR [EDI+7Eh],2800h

{  MOV DX,03CBh
@lineh_ark_busy:
  IN AL,DX
  TEST AL,40h
  JNZ @lineh_ark_busy }
END;

{-------------------------------- lineH_pattern -----------------------------}

{-------------------------------- bar -------------------------------------}

PROCEDURE bar_ark(x1,y1,x2,y2,f:longint);assembler;
ASM
  MOV EDI,mmiooffs
  MOV WORD PTR [EDI+18h],0305h
  MOV EAX,f
  MOV [EDI+02h],AX
  SHR EAX,16
  MOV [EDI+06h],AX

  MOV EAX,x1
  MOV EBX,x2
  CMP EAX,EBX
  JLE @bar_ark_w1
  XCHG EBX,EAX
@bar_ark_w1:
  MOV [EDI+70h],AX
  SUB EBX,EAX
  MOV [EDI+74h],BX

  MOV EAX,y1
  MOV EBX,y2
  CMP EAX,EBX
  JLE @bar_ark_w2
  XCHG EAX,EBX
@bar_ark_w2:
  SUB EBX,EAX
  MOV [EDI+76h],BX
  ADD EAX,frontdrawoffsety
  MOV [EDI+72h],AX

  MOV WORD PTR [EDI+7Ch],0000h
  MOV WORD PTR [EDI+7Eh],2800h

  MOV DX,03CBh
@bar_ark_busy:
  IN AL,DX
  TEST AL,40h
  JNZ @bar_ark_busy
END;

{-------------------------------- bar_pattern -------------------------------}
{
PROCEDURE bar_pattern_ark(x1,y1,x2,y2,f:longint);assembler;
ASM
  MOV EDI,mmiooffs
  MOV WORD PTR [EDI+18h],0305h
  MOV EAX,f
  MOV [EDI+02h],AX
  SHR EAX,16
  MOV [EDI+06h],AX

  MOV EAX,x1
  MOV EBX,x2
  CMP EAX,EBX
  JLE @bar_ark_w1
  XCHG EBX,EAX
@bar_ark_w1:
  MOV [EDI+70h],AX
  SUB EBX,EAX
  MOV [EDI+74h],BX

  MOV EAX,y1
  MOV EBX,y2
  CMP EAX,EBX
  JLE @bar_ark_w2
  XCHG EAX,EBX
@bar_ark_w2:
  MOV [EDI+72h],AX
  SUB EBX,EAX
  MOV [EDI+76h],BX

  MOV WORD PTR [EDI+7Ch],0001h
  MOV WORD PTR [EDI+7Eh],2C10h

  MOV DX,03CBh
@bar_ark_busy:
  IN AL,DX
  TEST AL,40h
  JNZ @bar_ark_busy
END;
}
{-------------------------------- barXOR ----------------------------------}

PROCEDURE barxor_ark(x1,y1,x2,y2,f:longint);assembler;
ASM
  MOV EDI,mmiooffs
  MOV WORD PTR [EDI+18h],0605h
  MOV EAX,f
  MOV [EDI+02h],AX
  SHR EAX,16
  MOV [EDI+06h],AX

  MOV EAX,x1
  MOV EBX,x2
  CMP EAX,EBX
  JLE @bar_ark_w1
  XCHG EBX,EAX
@bar_ark_w1:
  MOV [EDI+70h],AX
  SUB EBX,EAX
  MOV [EDI+74h],BX

  MOV EAX,y1
  MOV EBX,y2
  CMP EAX,EBX
  JLE @bar_ark_w2
  XCHG EAX,EBX
@bar_ark_w2:
  SUB EBX,EAX
  MOV [EDI+76h],BX
  ADD EAX,frontdrawoffsety
  MOV [EDI+72h],AX

  MOV WORD PTR [EDI+7Ch],0000h
  MOV WORD PTR [EDI+7Eh],2800h

  MOV DX,03CBh
@bar_ark_busy:
  IN AL,DX
  TEST AL,40h
  JNZ @bar_ark_busy
END;

{-------------------------------- barXOR_pattern ----------------------------}

{------------------------- moverect -----------------------------------------}

PROCEDURE moverect_ark(x1,y1,x2,y2,x,y:longint);
VAR h:longint;
BEGIN
  IF (x1>x2) THEN BEGIN h:=x1;x1:=x2;x2:=h; END;
  IF (y1>y2) THEN BEGIN h:=y1;y1:=y2;y2:=h; END;
  word(pointer(mmiooffs+$18)^):=$0305;
  IF (x<x1) OR (y<y1) THEN
    BEGIN
      word(pointer(mmiooffs+$6C)^):=word(x1);
      word(pointer(mmiooffs+$6E)^):=word(y1)+word(frontdrawoffsety);
      word(pointer(mmiooffs+$70)^):=word(x);
      word(pointer(mmiooffs+$72)^):=word(y+frontdrawoffsety);
      word(pointer(mmiooffs+$74)^):=word(x2-x1);
      word(pointer(mmiooffs+$76)^):=word(y2-y1);
      word(pointer(mmiooffs+$7C)^):=0;
      word(pointer(mmiooffs+$7E)^):=$2900;
    END
  ELSE
    BEGIN
      word(pointer(mmiooffs+$6C)^):=word(x2);
      word(pointer(mmiooffs+$6E)^):=word(y2)+word(frontdrawoffsety);
      word(pointer(mmiooffs+$70)^):=word(x+x2-x1);
      word(pointer(mmiooffs+$72)^):=word(y+y2-y1+frontdrawoffsety);
      word(pointer(mmiooffs+$74)^):=word(x2-x1);
      word(pointer(mmiooffs+$76)^):=word(y2-y1);
      word(pointer(mmiooffs+$7C)^):=0;
      word(pointer(mmiooffs+$7E)^):=$2907;
    END;
  ASM
    MOV DX,03CBh
  @bar_ark_busy:
    IN AL,DX
    TEST AL,40h
    JNZ @bar_ark_busy
  END;
END;

{============================================================================}

PROCEDURE setreslist_ark(var modelist:PModeEntry);
BEGIN
  AddModeToList(modelist,$4F,  640, 400,1,  640, $50,0,0,  5,3,2,3,0,2, ig_bank+ig_lfb+ig_hwa+ig_col8);
  AddModeToList(modelist,$40,  640, 480,1,  640, $50,0,0,  5,3,2,3,0,2, ig_bank+ig_lfb+ig_hwa+ig_col8);
  AddModeToList(modelist,$50,  640, 480,2, 1280, $A0,0,0, 10,5,5,5,0,5, ig_bank+ig_lfb+ig_hwa+ig_col15);
  AddModeToList(modelist,$54,  640, 480,2, 1280, $A0,0,0, 11,5,5,6,0,5, ig_bank+ig_lfb+ig_hwa+ig_col16);
  AddModeToList(modelist,$58,  640, 480,3, 1920, $F0,0,0, 16,8,8,8,0,8, ig_bank+ig_lfb{+ig_hwa}+ig_col24);
  AddModeToList(modelist,$41,  800, 600,1,  800, $64,0,0,  5,3,2,3,0,2, ig_bank+ig_lfb+ig_hwa+ig_col8);
  AddModeToList(modelist,$51,  800, 600,2, 1600, $C8,0,0, 10,5,5,5,0,5, ig_bank+ig_lfb+ig_hwa+ig_col15);
  AddModeToList(modelist,$55,  800, 600,2, 1600, $C8,0,0, 11,5,5,6,0,5, ig_bank+ig_lfb+ig_hwa+ig_col16);
  AddModeToList(modelist,$59,  800, 600,3, 2400,$12C,0,0, 16,8,8,8,0,8, ig_bank+ig_lfb{+ig_hwa}+ig_col24);
  AddModeToList(modelist,$42, 1024, 768,1, 1024, $80,0,0,  5,3,2,3,0,2, ig_bank+ig_lfb+ig_hwa+ig_col8);
  AddModeToList(modelist,$52, 1024, 768,2, 2048,$100,0,0, 10,5,5,5,0,5, ig_bank+ig_lfb+ig_hwa+ig_col15);
  AddModeToList(modelist,$56, 1024, 768,2, 2048,$100,0,0, 11,5,5,6,0,5, ig_bank+ig_lfb+ig_hwa+ig_col16);
  AddModeToList(modelist,$5A, 1024, 768,3, 3072,$180,0,0, 16,8,8,8,0,8, ig_bank+ig_lfb{+ig_hwa}+ig_col24);
  AddModeToList(modelist,$43, 1280,1024,1, 1280, $A0,0,0,  5,3,2,3,0,2, ig_bank+ig_lfb+ig_hwa+ig_col8);
  AddModeToList(modelist,$53, 1280,1024,2, 2560,$140,0,0, 10,5,5,5,0,5, ig_bank+ig_lfb+ig_hwa+ig_col15);
  AddModeToList(modelist,$57, 1280,1024,2, 2560,$140,0,0, 11,5,5,6,0,5, ig_bank+ig_lfb+ig_hwa+ig_col16);
  AddModeToList(modelist,$44, 1600,1200,1, 1600, $C8,0,0,  5,3,2,3,0,2, ig_bank+ig_lfb+ig_hwa+ig_col8);
  AddModeToList(modelist,$5D, 1600,1200,2, 3200,$190,0,0, 10,5,5,5,0,5, ig_bank+ig_lfb+ig_hwa+ig_col15);
  AddModeToList(modelist,$5E, 1600,1200,2, 3200,$190,0,0, 11,5,5,6,0,5, ig_bank+ig_lfb+ig_hwa+ig_col16);
END;

{============================================================================}

PROCEDURE sethwaprocs_ark(col:longint);
BEGIN
  graphwinHW:=@graphwinHW_ark;
  setpatternHW:=@setpatternHW_ark;
  lineh:=@lineh_ark;
  lineh_solid:=@lineh_ark;
  bar:=@bar_ark;
  bar_solid:=@bar_ark;
{  bar_pattern:=@bar_pattern_ark; }
  barxor:=@barxor_ark;
  barxor_solid:=@barxor_ark;
  moverect:=@moverect_ark;
END;


END.
