{
    This file is a part of the graphics library GraphiX
    Copyright (C) 2001 Michael Knapp

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
}

{$I gxglobal.cfg}
UNIT gxvgalib;

INTERFACE

USES gxsup;
{$I gxlocal.cfg}

PROCEDURE init_vgalib;
PROCEDURE done_vgalib;
PROCEDURE scanmodes_vgalib(var modelist:PModeEntry;overrideflags:dword);
FUNCTION getmemsize_vgalib:word;
FUNCTION getaddress_vgalib:longint;
FUNCTION getlinearaddress_vgalib:longint;
PROCEDURE initmode_vgalib(mode:word);
PROCEDURE scanline_vgalib(linewidth:word);
PROCEDURE displaystart_vgalib(offs:dword);
PROCEDURE bankswitch_vgalib;
PROCEDURE retrace_vgalib;
PROCEDURE retraceend_vgalib;
PROCEDURE retracestart_vgalib;
PROCEDURE setrgbcolor_vgalib(nr,R,G,B:byte);

PROCEDURE initmouse_vgalib;
PROCEDURE donemouse_vgalib;
PROCEDURE setmousehandler_vgalib(cb:pointer);
FUNCTION getmousex_vgalib:longint;
FUNCTION getmousey_vgalib:longint;
FUNCTION getmousebutton_vgalib:byte;

IMPLEMENTATION

USES svgalib,vgamouse;

PROCEDURE init_vgalib;
BEGIN
  vga_init;
END;

PROCEDURE done_vgalib;
BEGIN
  vga_setmode(GTEXT);
END;

PROCEDURE scanmodes_vgalib(var modelist:PModeEntry;overrideflags:dword);
VAR i,flags:longint;
    mi:pvga_modeinfo;
    redmaskpos,redmasksize:byte;
    greenmaskpos,greenmasksize:byte;
    bluemaskpos,bluemasksize:byte;
BEGIN
  FOR i:=1 TO 255 DO
    BEGIN
      IF vga_hasmode(i) THEN
        BEGIN
          mi:=vga_getmodeinfo(i);
          flags:=ig_bank;
          IF (mi^.flags AND IS_LINEAR=IS_LINEAR) THEN flags:=flags OR ig_lfb;
          CASE mi^.colors OF
          256:
            BEGIN
              flags:=flags OR ig_col8;
              redmaskpos:=5;
              redmasksize:=3;
              greenmaskpos:=2;
              greenmasksize:=3;
              bluemaskpos:=0;
              bluemasksize:=2;
            END;
          32768:
            BEGIN
              flags:=flags OR ig_col15;
              redmaskpos:=10;
              redmasksize:=5;
              greenmaskpos:=5;
              greenmasksize:=5;
              bluemaskpos:=0;
              bluemasksize:=5;
            END;
          65536:
            BEGIN
              flags:=flags OR ig_col16;
              redmaskpos:=11;
              redmasksize:=5;
              greenmaskpos:=5;
              greenmasksize:=6;
              bluemaskpos:=0;
              bluemasksize:=5;
            END;
          16777216:
            BEGIN
              CASE mi^.bytesperpixel OF
              3:flags:=flags OR ig_col24;
              4:flags:=flags OR ig_col32;
              END;
              IF (mi^.flags AND RGB_MISORDERED=0) THEN
                BEGIN
                  redmaskpos:=16;
                  redmasksize:=8;
                  greenmaskpos:=8;
                  greenmasksize:=8;
                  bluemaskpos:=0;
                  bluemasksize:=8;
                END
              ELSE
                BEGIN
                  redmaskpos:=0;
                  redmasksize:=8;
                  greenmaskpos:=8;
                  greenmasksize:=8;
                  bluemaskpos:=16;
                  bluemasksize:=8;
                END;
            END;
          END;
          IF (mi^.flags AND IS_MODEX=0) AND (mi^.colors>=256) THEN
            AddModeToList(modelist,i,mi^.width,mi^.height,
                          mi^.bytesperpixel,mi^.linewidth,mi^.linewidth,0,0,
                          redmaskpos,redmasksize,
                          greenmaskpos,greenmasksize,
                          bluemaskpos,bluemasksize,
                          flags);
        END;
    END;
END;

FUNCTION getmemsize_vgalib:word;
BEGIN
  getmemsize_vgalib:=4096;
END;

FUNCTION getaddress_vgalib:longint;
BEGIN
  getaddress_vgalib:=longint(vga_getgraphmem);
END;

FUNCTION getlinearaddress_vgalib:longint;
BEGIN
  getlinearaddress_vgalib:=vga_setlinearaddressing;
END;

PROCEDURE initmode_vgalib(mode:word);
BEGIN
  vga_setmode(GTEXT);
  vga_setmode(mode);
END;

PROCEDURE scanline_vgalib(linewidth:word);
BEGIN
  vga_setlogicalwidth(linewidth);
END;

PROCEDURE displaystart_vgalib(offs:dword);
BEGIN
  vga_setdisplaystart(offs)
END;

PROCEDURE setpage(p:longint);
BEGIN
  vga_setpage(p);
END;

PROCEDURE bankswitch_vgalib;assembler;
ASM
  PUSHA
  AND EDX,0FFFFh
  PUSH EDX
  CALL setpage
  POPA
END;

PROCEDURE retrace_vgalib;
BEGIN
  vga_waitretrace;
END;

PROCEDURE retraceend_vgalib;
BEGIN
  vga_waitretrace;
END;

PROCEDURE retracestart_vgalib;
BEGIN
  vga_waitretrace;
END;

PROCEDURE setrgbcolor_vgalib(nr,R,G,B:byte);
BEGIN
  vga_setpalette(nr,R,G,B);
END;

{-----------------}

VAR MouseCallBack:procedure;
    MouseCallBackUsed:boolean;
    MouseX,MouseY,MouseButton:longint;

PROCEDURE mousehandler(bn,dx,dy,dz,drx,dry,drz:longint);cdecl;
BEGIN
{  inc(MouseX,dx);
  inc(MouseY,dy);
  MouseButton:=0;
  IF (bn AND mouse_leftbutton<>0) THEN MouseButton:=(MouseButton OR 1);
  IF (bn AND mouse_rightbutton<>0) THEN MouseButton:=(MouseButton OR 2);
  IF (bn AND mouse_middlebutton<>0) THEN MouseButton:=(MouseButton OR 4); }
  IF MouseCallbackUsed THEN MouseCallback;
END;

PROCEDURE initmouse_vgalib;
BEGIN
  vga_setmousesupport(1);
  mouse_setscale(16);
{  mouse_seteventhandler(@mousehandler); }
END;

PROCEDURE donemouse_vgalib;
BEGIN
{  mouse_setdefaulteventhandler; }
END;

TYPE callbackproc=procedure;

PROCEDURE setmousehandler_vgalib(cb:pointer);
BEGIN
  IF (cb=nil) THEN MouseCallbackUsed:=FALSE;
  MouseCallback:=callbackproc(cb);
  IF (cb<>nil) THEN MouseCallbackUsed:=TRUE;
END;

FUNCTION getmousex_vgalib:longint;
BEGIN
  mouse_update;
  getmousex_vgalib:=mouse_getx;
{  getmousex_vgalib:=MouseX; }
END;

FUNCTION getmousey_vgalib:longint;
BEGIN
  mouse_update;
  getmousey_vgalib:=mouse_gety;
{  getmousey_vgalib:=MouseY; }
END;

FUNCTION getmousebutton_vgalib:byte;
VAR button:byte;
    mb:longint;
BEGIN
  mouse_update;
  mb:=mouse_getbutton;
  button:=0;
  IF (mb AND mouse_leftbutton<>0) THEN button:=(button OR 1);
  IF (mb AND mouse_rightbutton<>0) THEN button:=(button OR 2);
  IF (mb AND mouse_middlebutton<>0) THEN button:=(button OR 4);
  getmousebutton_vgalib:=button;
{  getmousebutton_vgalib:=MouseButton; }
END;

{==========================================================================}

VAR OldExitProc:pointer;

PROCEDURE NewExitProc;
BEGIN
  ExitProc:=OldExitProc;
  done_vgalib;
END;

BEGIN
  MouseCallbackUsed:=FALSE;
  OldExitProc:=ExitProc;
  ExitProc:=@NewExitProc;
  init_vgalib;
END.