program telsort3;

{$APPTYPE CONSOLE}

uses
  SysUtils, DateUtils, Classes;

const buff_count = 16384; //   32768 16384  8192  4096 2048
      Longword_bits = SizeOf(Longword) * 8;  // 32
      bit_count = 240000 * Longword_bits;    // 7680000
      max_number = 10000000;

var i,t :Longword;
    f,fs :TFileStream;        //  
    s,s_last :string;
    Start,Stop :TDateTime;    //   
    pbuff :PChar;             //   
    ps,pe :PChar;             //     
    pbuff_read :longint;      //     
    radix :array of Longword; //       
    last_number_count,number_count :Longword; //   

function GetUsedRAM: Cardinal;      //    
begin
    Result:=GetHeapStatus.TotalAllocated;
end;

procedure SetBit(var L :Longword; b :byte);  //    32- 
var R :Longword;
begin
  if b>31 then exit; //    Longword
  R:=1 shl b;    //    b- -  b-   R  1
  L:= L or R;    //  b-   L  1
end;

function GetBit(L :Longword; b :byte):boolean; //    32- 
var R :Longword;
begin
  Result := false;
  if b>31 then exit;
  R:=1 shl b;    //    b- -  b-   R  1
  Result := (L and R)>0; //    b-   L  1
end;

begin
  writeln('RAM=',GetUsedRAM);
  Start:=Now;

  //     
  f:=TFileStream.Create('tel.txt',fmOpenRead);
  //      
  fs:=TFileStream.Create('tels.txt',fmOpenWrite or fmCreate);

  GetMem(pbuff,buff_count+1);   //     
  setlength(radix,bit_count div Longword_bits); //     
  number_count:=bit_count; //       
  last_number_count:=0;

  repeat
    for i:= 0 to length(radix)-1 do radix[i]:=0; //   

    if last_number_count>0 then
      f.Seek(0,soFromBeginning); //       

    s_last:='';
    repeat
      pbuff_read:=f.Read(pbuff^,buff_count);   //   
      ps:=pbuff;                               //    
      repeat
        pe:=ps; //   
        while (pe<(pbuff+pbuff_read))and(not (pe[0] in [#10,#13])) do inc(pe);
        if pe<(pbuff+pbuff_read) then
        begin
          if pe=ps then
          begin   //   
            while (ps<(pbuff+pbuff_read))and(ps[0] in [#10,#13]) do inc(ps);
            pe:=ps;
            if length(s_last)>0 then
            begin
              s:=s_last;  //          
              s_last:='';
            end;
          end
          else
          begin
            SetString(s,ps,pe-ps);  //    
            s:=s_last+s;            //       
            s_last:='';
          end;
          if length(s)>0 then
          begin
            t:=StrToInt(s);    //  
            if (t>=last_number_count)and(t<number_count) then
            begin  //         
              dec(t,last_number_count);
              //      
              SetBit(radix[t div Longword_bits],t mod Longword_bits);
            end;
            s:=''; //   
          end;
          if ps<>pe then ps:=pe+2;  //      #13#10
        end;
      until pe>=(pbuff+pbuff_read);   //      
      SetString(s_last,ps,pbuff_read-(ps-pbuff)); //      

    until pbuff_read<>buff_count;  //    

    //       
    ps:=pbuff;            //    
    pe:=pbuff+buff_count; //    
    for t:=0 to number_count-last_number_count-1 do
      if GetBit(radix[t div Longword_bits],t mod Longword_bits) then
      begin
        s:=IntToStr(t+last_number_count)+#13#10; //     +  
        if (length(s)+1)>(pe-ps) then //    -   
        begin
          if fs.Write(pbuff^,ps-pbuff)<>(ps-pbuff) then
            writeln('Result file write error!'); //  
          ps:=pbuff;
        end;
        StrPCopy(ps,s);      //     
        inc(ps,length(s));   //      
      end;
    if fs.Write(pbuff^,ps-pbuff)<>(ps-pbuff) then  //     
      writeln('Result file write error!'); //  

    last_number_count:=number_count; //        
    inc(number_count,bit_count);
    writeln('RAM=',GetUsedRAM);
  until last_number_count>max_number;

  f.Free;       //    
  fs.Free;      //      
  FreeMem(pbuff);    //   
  setlength(radix,0);

  Stop:=Now;
  writeln(IntToStr(MilliSecondsBetween(Start,Stop))); //    
  writeln('RAM=',GetUsedRAM);
end.

