unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Menus;

Const
  maxPoint = 100;
    
type
  TForm1 = class(TForm)
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Start1: TMenuItem;
    N1: TMenuItem;
    Exit1: TMenuItem;
    procedure FormMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Start1Click(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    myPoints: Array[1 .. maxPoint] Of TPoint;
    procedure StartAlgorithm;
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

Var
  myCount: Integer = 0;

procedure TForm1.FormMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
const
  sz = 3;
begin
  Canvas.Pen.Color := clRed;
  Canvas.Ellipse(X - sz, Y - sz, X + sz, Y + sz);

  If myCount < maxPoint Then
    Begin
      Inc(myCount);
      myPoints[myCount].X := X;
      myPoints[myCount].Y := Y;
    End;
end;

procedure TForm1.Start1Click(Sender: TObject);
begin
  StartAlgorithm;
end;

Procedure TForm1.StartAlgorithm;

  Function GetDist(Var a, b: TPoint): LongInt;
    Begin
      Result := Trunc(Sqrt(Sqr(a.X - b.X) + Sqr(a.Y - b.Y)))
    End;

  Function Sign(a: LongInt): Integer;
    Begin
      Result := 1;
      If a < 0 Then Result := -1
    End;

  Function FindOuterRadius(A, B, C : TPoint; Var Rr : TPoint): Boolean;
    Var
      m: Array[1 .. 2, 1 .. 3] Of Extended;
      D, Dx, Dy: Extended;
    Begin
      m[1, 1] := 2 * (A.X - B.X);
      m[1, 2] := 2 * (A.Y - B.Y);
      m[1, 3] := Sqr(A.X) + Sqr(A.Y) - (Sqr(B.X) + Sqr(B.Y));

      m[2, 1] := 2 * (B.X - C.X);
      m[2, 2] := 2 * (B.Y - C.Y);
      m[2, 3] := Sqr(B.X) + Sqr(B.Y) - (Sqr(C.X) + Sqr(C.Y));

      D := m[1, 1] * m[2, 2] - m[2, 1] * m[1, 2];
      Dx := m[1, 3] * m[2, 2] - m[2, 3] * m[1, 2];
      Dy := m[1, 1] * m[2, 3] - m[2, 1] * m[1, 3];

      If D <> 0 Then
        Begin
          Rr.X := Trunc(Dx/D); Rr.Y := Trunc(Dy/D);
          FindOuterRadius := True
        End
      Else
        Begin
          Rr.X := 0; Rr.Y := 0;
          FindOuterRadius := False;
        End;
    End;

const
  sz = 3;
Var
  i, j, maxI, maxJ, maxIndex: Integer;
  maxPrev, max, Dist: LongInt;
  ThePoint, p, myCenter: TPoint;
  myRadius: Integer;
  wasExceeded: Boolean;
Begin
  max := 0; maxI := 0; maxJ := 0;
  For i := 1 To myCount Do
    For j := 1 To myCount Do
      If i <> j Then
        Begin
          Dist := GetDist(myPoints[i], myPoints[j]);
          If Dist > max Then
            Begin
              max := Dist; maxI := i; maxJ := j
            End;
        End;

  { max distance found... Now get third point with max Dist
    from center of (AB) - ThePoint }
  ThePoint.X := (myPoints[maxI].X + myPoints[maxJ].X) Div 2;
  ThePoint.Y := (myPoints[maxI].Y + myPoints[maxJ].Y) Div 2;

  maxPrev := max Div 2;
  max := 0; maxIndex := 0;
  wasExceeded := False;
  For i := 1 To myCount Do
    If (i <> maxI) And (i <> maxJ) Then
        Begin
          Dist := GetDist(ThePoint, myPoints[i]);
          wasExceeded := wasExceeded Or (Dist > maxPrev);
          If Dist > max Then
            Begin
              max := Dist; maxIndex := i
            End;
        End;

  If wasExceeded Then
    Begin
      If FindOuterRadius(myPoints[maxI], myPoints[maxJ],
         myPoints[maxIndex], myCenter) Then
        Begin
          myRadius := GetDist(myCenter, myPoints[maxI]);
        End
    End
  Else
    Begin
      myRadius := maxPrev; myCenter := ThePoint;
    End;

  Canvas.Pen.Color := clBlack;
  Canvas.Ellipse(myCenter.X-myRadius, myCenter.Y-myRadius,
                 myCenter.X+myRadius, myCenter.Y+myRadius);

  Canvas.Pen.Color := clRed;
  Canvas.Ellipse(myCenter.X-sz, myCenter.Y-sz,
                 myCenter.X+sz, myCenter.Y+sz);

  For i := 1 To myCount Do
    Begin
      If (i = maxI)Or(i = maxJ)Or(i = maxIndex)
        Then Canvas.Pen.Color := clBlue
      Else Canvas.Pen.Color := clBlack;

      p := myPoints[i];
      Canvas.Ellipse(p.X - sz, p.Y - sz, p.X + sz, p.Y + sz);
    End;

End;

procedure TForm1.Exit1Click(Sender: TObject);
begin
   Self.Close;
end;

end.
