// ==UserScript==
// @name           QuickSyntax
// @namespace      volvo71@narod.ru
// @description    -- Quick Syntax Highlight
// @include        http://forum.pascalnet.ru/*
// ==/UserScript==

/* 
Syntax highlighting with language autodetection.  
http://softwaremaniacs.org/soft/highlight/
*/

var hljs = new function () {
	var DEFAULT_LANGUAGES = ['python', 'ruby', 'perl', 'php', 'css', 'xml', 'html', 'django', 'javascript', 'java', 'cpp', 'sql', 'smalltalk', 'ini', 'diff'];
	var ALL_LANGUAGES = (DEFAULT_LANGUAGES.join(',') + ',' + ['1c', 'axapta', 'delphi', 'rib', 'rsl', 'vbscript', 'profile', 'dos', 'bash'].join(',')).split(',');
	var LANGUAGE_GROUPS = {
		'xml': 'www',
		'html': 'www',
		'css': 'www',
		'django': 'www',
		'python': 'dynamic',
		'perl': 'dynamic',
		'php': 'dynamic',
		'ruby': 'dynamic',
		'cpp': 'static',
		'java': 'static',
		'delphi': 'static',
		'rib': 'renderman',
		'rsl': 'renderman'
	};
	
	var LANGUAGES = {};
	var selected_languages = {};
	
	function escape(value) {
		return value.replace(/&/gm, '&amp;').replace(/</gm, '&lt;').replace(/>/gm, '&gt;');
	}
	
	function contains(array, item) {
		if (!array) {
			return false;
		}
		for (var key in array) {
			if (array[key] == item) {
				return true;
			}
		}
		return false;
	}
	
	function highlight(language_name, value) {
		function compileSubModes(mode, language) {
			mode.sub_modes = [];
			for (var i in mode.contains) {
				for (var j in language.modes) {
					if (language.modes[j].className == mode.contains[i]) {
						mode.sub_modes[mode.sub_modes.length] = language.modes[j];
					}
				}
			}
		}
		
		function subMode(lexem, mode) {
			if (!mode.contains) {
				return null;
			}
			if (!mode.sub_modes) {
				compileSubModes(mode, language);
			}
			
			for (var i = 0; i < mode.sub_modes.length; i++) {
				if (mode.sub_modes[i].beginRe.test(lexem)) {
					return mode.sub_modes[i];
				}
			}
			return null;
		}
		
		function endOfMode(mode_index, lexem) {
			if (modes[mode_index].end && modes[mode_index].endRe.test(lexem)) {
				return 1;
			}
			if (modes[mode_index].endsWithParent) {
				var level = endOfMode(mode_index - 1, lexem);
				return level ? level + 1 : 0;
			}
			return 0;
		}
		
		function isIllegal(lexem, mode) {
			return mode.illegalRe && mode.illegalRe.test(lexem);
		}
		
		function compileTerminators(mode, language) {
			var terminators = [];
			
			function addTerminator(re) {
				if (!contains(terminators, re)) {
					terminators[terminators.length] = re;
				}
			}
			
			if (mode.contains) {
				for (var key in language.modes) {
					if (contains(mode.contains, language.modes[key].className)) {
						addTerminator(language.modes[key].begin);
					}
				}
			}
			var index = modes.length - 1;
			do {
				if (modes[index].end) {
					addTerminator(modes[index].end);
				}
				index--;
			} while (modes[index + 1].endsWithParent);
			
			if (mode.illegal) {
				addTerminator(mode.illegal);
			}
			
			var terminator_re = '(' + terminators[0];
			for (var i = 0; i < terminators.length; i++) {
				terminator_re += '|' + terminators[i];
			}
			terminator_re += ')';
			return langRe(language, terminator_re);
		}
		
		function eatModeChunk(value, index) {
			var mode = modes[modes.length - 1];
			if (!mode.terminators) {
				mode.terminators = compileTerminators(mode, language);
			}
			value = value.substr(index);
			var match = mode.terminators.exec(value);
			if (!match) {
				return [value, '', true];
			}
			
			if (match.index == 0) { 
				return ['', match[0], false];
			}
			else {
				return [value.substr(0, match.index), match[0], false];
			}
		}
		
		function keywordMatch(mode, match) {
			var match_str = language.case_insensitive ? match[0].toLowerCase() : match[0];
			for (var className in mode.keywordGroups) {
				var value = mode.keywordGroups[className].hasOwnProperty(match_str);
				if (value) {
					return [className, value];
				}
			}
			return false;
		}
		
		function processKeywords(buffer, mode) {
			if (!mode.keywords || !mode.lexems) {
				return escape(buffer);
			}
			if (!mode.lexemsRe) {
				var lexems_re = '(' + mode.lexems[0];
				for (var i = 1; i < mode.lexems.length; i++) {
					lexems_re += '|' + mode.lexems[i];
				}
				lexems_re += ')';
				mode.lexemsRe = langRe(language, lexems_re, true);
			}
			var result = '';
			var last_index = 0;
			mode.lexemsRe.lastIndex = 0;
			var match = mode.lexemsRe.exec(buffer);
			while (match) {
				result += escape(buffer.substr(last_index, match.index - last_index));
				keyword_match = keywordMatch(mode, match);
				if (keyword_match) {
					keyword_count += keyword_match[1];
					result += '<span class="' + keyword_match[0] + '">' + escape(match[0]) + '</span>';
				}
				else {
					result += escape(match[0]);
				}
				last_index = mode.lexemsRe.lastIndex;
				match = mode.lexemsRe.exec(buffer);
			}
			result += escape(buffer.substr(last_index, buffer.length - last_index));
			return result;
		}
		
		function processBuffer(buffer, mode) {
			if (mode.subLanguage && selected_languages[mode.subLanguage]) {
				var result = highlight(mode.subLanguage, buffer);
				keyword_count += result.keyword_count;
				relevance += result.relevance;
				return result.value;
			}
			else {
				return processKeywords(buffer, mode);
			}
		}
		
		function startNewMode(mode, lexem) {
			if (mode.returnBegin) {
				result += '<span class="' + mode.className + '">';
				mode.buffer = '';
			}
			else
				if (mode.excludeBegin) {
					result += escape(lexem) + '<span class="' + mode.className + '">';
					mode.buffer = '';
				}
				else {
					result += '<span class="' + mode.className + '">';
					mode.buffer = lexem;
				}
			modes[modes.length] = mode;
		}
		
		function processModeInfo(buffer, lexem, end) {
			var current_mode = modes[modes.length - 1];
			if (end) {
				result += processBuffer(current_mode.buffer + buffer, current_mode);
				return false;
			}
			
			var new_mode = subMode(lexem, current_mode);
			if (new_mode) {
				result += processBuffer(current_mode.buffer + buffer, current_mode);
				startNewMode(new_mode, lexem);
				relevance += new_mode.relevance;
				return new_mode.returnBegin;
			}
			
			var end_level = endOfMode(modes.length - 1, lexem);
			if (end_level) {
				if (current_mode.returnEnd) {
					result += processBuffer(current_mode.buffer + buffer, current_mode) + '</span>';
				}
				else
					if (current_mode.excludeEnd) {
						result += processBuffer(current_mode.buffer + buffer, current_mode) + '</span>' + escape(lexem);
					}
					else {
						result += processBuffer(current_mode.buffer + buffer + lexem, current_mode) + '</span>';
					}
				
				while (end_level > 1) {
					result += '</span>';
					end_level--;
					modes.length--;
				}
				
				modes.length--;
				modes[modes.length - 1].buffer = '';
				if (current_mode.starts) {
					for (var i = 0; i < language.modes.length; i++) {
						if (language.modes[i].className == current_mode.starts) {
							startNewMode(language.modes[i], '');
							break;
						}
					}
				}
				return current_mode.returnEnd;
			}
			
			if (isIllegal(lexem, current_mode)) { throw 'Illegal'; }
		}
		
		var language = LANGUAGES[language_name];
		var modes = [language.defaultMode];
		var relevance = 0;
		var keyword_count = 0;
		var result = '';
		try {
			var index = 0;
			language.defaultMode.buffer = '';
			do {
				var mode_info = eatModeChunk(value, index);
				var return_lexem = processModeInfo(mode_info[0], mode_info[1], mode_info[2]);
				
				index += mode_info[0].length;
				if (!return_lexem) {
					index += mode_info[1].length;
				}
			} while (!mode_info[2]); 
			
			if (modes.length > 1) {
				throw 'Illegal';
			}
			return {
				relevance: relevance,
				keyword_count: keyword_count,
				value: result
			}
		}
		catch (e) {
			if (e == 'Illegal') {
				return {
					relevance: 0,
					keyword_count: 0,
					value: escape(value)
				}
			}
			else {
				throw e;
			}
		}
	}
	
	function blockText(block) {
		var result = '';
		for (var i = 0; i < block.childNodes.length; i++) {
			if (block.childNodes[i].nodeType == 3) {
				result += block.childNodes[i].nodeValue;
			}
			else
				if (block.childNodes[i].nodeName == 'BR') { result += '\n'; }
				else { throw 'No highlight'; }
		}
		return result;
	}
	
	function blockLanguage(block) {
		var classes = block.id.split(/\s+/);
		for (var i = 0; i < classes.length; i++) {

			if (classes[i] == 'no-highlight') {
				throw 'No highlight';
			}
				// alert(classes[i]);
			if (LANGUAGES[classes[i]]) {
			// alert(classes[i]);
				return classes[i];
			}
		}
	}
	
	function highlightBlock(block) {
		try {
			var text = blockText(block);
			var language = blockLanguage(block);
			
		}
		catch (e) {
			if (e == 'No highlight') { return; }
		}
			
		if (language) {
			// Additional PAS-like languages go here
			var result = highlight(language, text).value;
		}
		else {
		// auto
		/*
			var max_relevance = 2;
			var relevance = 0;
			for (var key in selected_languages) {
				var r = highlight(key, text);
				relevance = r.keyword_count + r.relevance;
				if (relevance > max_relevance) {
					max_relevance = relevance;
					var result = r.value;
					language = key;
				}
			}
		*/
		}
		
		if (result) {
			// -- added by Volvo
			result = result.replace(//gi, "(c)").replace(//gi, "(r)").replace(/\u00A9/gi, "(c)").replace(/\u00AE/gi, '(r)');
			// -- added by Volvo
			var className = block.id;
			if (!className.match(language)) {
				className += ' ' + language;
			}
			
			/*
			-- added by volvo
			*/
			
			// feb, 1 2009 update !!!
			var sL = result.split("</span>\n");
			var nowSpanIs = "";
			for (var ii = 0; ii < sL.length; ii++) {
				var curr_st = sL[ii] + "</span>";
				currLst = curr_st.split("\n");
				for (var j = 0; j < currLst.length; j++) {
					currLst[j] = nowSpanIs + currLst[j];
					var start = currLst[j].lastIndexOf("<span");
					var finish = currLst[j].lastIndexOf("</span");
					if (start > finish) {
						var p = currLst[j].indexOf(">", start);
						nowSpanIs = currLst[j].substring(start, p + 1);
						currLst[j] += "</span>";
					}
					else if (finish > start) {
						nowSpanIs = "";
					}
				}
				sL[ii] = currLst.join("</td></tr><tr><td style=\"padding: 0px; width: 100%; height: 16px; line-height: 90%; text-align: left;\">");
			}
			result = sL.join("</td></tr><tr><td style=\"padding: 0px; width: 100%; height: 16px; line-height: 90%; text-align: left;\">");
			result = "<tr><td style=\"padding: 0px; width: 100%; height: 16px; line-height: 90%; text-align: left;\">" + result + "</td></tr>";
			
			var ff = result.match(/<tr>/g).length;
			var st = "";
			
			for (var i = 0; i < ff; i++) {
				st += '<tr><td style="padding: 0px; width: 100%; height: 16px; line-height: 90%; text-align: right;">' +
					(i + 1) + ':</td></tr>';
			}
			
			// added 20-nov-2009 (<button onClick="alert(\'test\');">Copy</button></span><br>)
			result = '<table width="100%"><tbody><tr><td width="5%" style="background-color: lightgray;"><table><tbody>' + 
				st + '</tbody></table></td><td width="95%"><table><tbody>' +
				result + '</tbody></table></td></tr></tbody></table>';
			// -- feb, 1 2009 update !!! 
			
			
			
			
			//alert(result);
			/*
			var sList = result.split("\n");
			for(var i = 0; i < sList.length; i++) {
				if(sList[i].lastIndexOf("<span") > sList[i].LastIndexOf("</span")) {
				}
			}
			var ss = "", st = "";
			for(var i = 0; i < sList.length; i++) {
				// alert(sList[i]);
				ss += '<tr><td style="padding: 0px; width: 100%; height: 16px; line-height: 90%; text-align: left;">' +
					sList[i] + '</td></tr>';
				st += '<tr><td style="padding: 0px; width: 100%; height: 16px; line-height: 90%; text-align: right;">' +
					(i+1) + ':</td></tr>';
			}
			result = '<table width="100%"><tbody><tr><td width="5%" style="background-color: lightgray;"><table><tbody>' + 
				st + '</tbody></table></td><td width="95%"><table><tbody>' +
				ss + '</tbody></table></td></tr></tbody></table>';
			*/
			/*
			// added 31 jan 2009
			result = '<table width="100%"><tbody><tr><td style="background-color: lightgray;">' +
				'<p><input type="button" value="Select Code" onClick="alert(this.parentElement.nodeType)"></p>' +
				'</td></tr><tr><td width="95%"><span name="inside_sel">' + 
				result + '</span></td></tr></tbody></table>';
			// -- added 31 jan 2009
			*/
			/*
			// added 30 jan 2009
			var ff = result.match(/\n/g).length;
			var st = "";
			for(var i = 1; i <= ff; i++) {
				st += i + ":"; if(i != ff) st += "\n";
			}
			result = '<table width="100%" align="center" border="0" cellpadding="3" cellspacing="1"><tbody><tr>' +
				'<td width="5%" style="white-space: normal; font-family: Courier New; font-size: 12px;' +
				' text-align: right;  color: navy; background-color: lightgray; border: 0px solid #000;' +
				' border-right-color:red; padding-top:2px; padding-right: 2px; padding-bottom: 2px; padding-left: 2px">'+ st +
				'</td><td width="95%">' + result + '</td></tr></tbody></table>';
			// -- added 30 jan 2009
			*/
			
			if (block.tagName.toLowerCase() == 'div') {
				block.innerHTML = '<pre border="1" bordercolor="000000">' + result + '</pre>';
				block.previousSibling.firstChild.nodeValue =
					block.previousSibling.firstChild.nodeValue +
					' (' + language.substr(0, language.indexOf('_')) + ')';
			}
			else {
				block.innerHTML = result;
			}
			/*
			-- added by volvo
			*/
		}
	}
	
	function langRe(language, value, global) {
		var mode =  'm' + (language.case_insensitive ? 'i' : '') + (global ? 'g' : '');
		return new RegExp(value, mode);
	}
	
	function compileModes() {
		for (var i in LANGUAGES) {
			var language = LANGUAGES[i];
			for (var key in language.modes) {
				if (language.modes[key].begin) {
					language.modes[key].beginRe = langRe(language, '^' + language.modes[key].begin);
				}
				if (language.modes[key].end) {
					language.modes[key].endRe = langRe(language, '^' + language.modes[key].end);
				}
				if (language.modes[key].illegal) {
					language.modes[key].illegalRe = langRe(language, '^(?:' + language.modes[key].illegal + ')');
				}
				language.defaultMode.illegalRe = langRe(language, '^(?:' + language.defaultMode.illegal + ')');
				if (language.modes[key].relevance == undefined) {
					language.modes[key].relevance = 1;
				}
			}
		}
	}
	
	function compileKeywords() {
		
		function compileModeKeywords(mode) {
			if (!mode.keywordGroups) {
				for (var key in mode.keywords) {
					if (mode.keywords[key] instanceof Object) {
						mode.keywordGroups = mode.keywords;
					}
					else {
						mode.keywordGroups = {'keyword': mode.keywords};
					}
					break;
				}
			}
		}
		
		for (var i in LANGUAGES) {
			var language = LANGUAGES[i];
			compileModeKeywords(language.defaultMode);
			for (var key in language.modes) {
				compileModeKeywords(language.modes[key]);
			}
		}
	}
	
	function initHighlighting() {
		if (initHighlighting.called) {
			return;
		}

		initHighlighting.called = true;
		compileModes();
		compileKeywords();
		if (arguments.length) {
			for (var i = 0; i < arguments.length; i++) {
				if (LANGUAGES[arguments[i]]) {
					selected_languages[arguments[i]] = LANGUAGES[arguments[i]];
				}
			}
		}
		else {
			selected_languages = LANGUAGES;
		}
		
		var pres = document.getElementsByTagName('pre');
				
		for(var ix = 0; ix < pres.length; ix++) {
			if (pres[ix].parentNode.tagName == 'div' && pres[ix].parentNode.className == 'codemain') {
				continue;
			}
			// alert("before:" + pres[ix].innerHTML);
			pres[ix].innerHTML = pres[ix].innerHTML.replace(/<img src=\"style_emoticons\/default\/(\d+).gif\" style=\"vertical-align:middle\" emoid=\":(\d+):\" alt=\"(\d+).gif\" border=\"0\">/g, ":$1:");
			// alert("pre = " + pres[ix].innerHTML);
			highlightBlock(pres[ix]);
		}
		
		/*
		-- volvo addition
		*/
		
		// and now - processing all of old-style codes
		// temporarily disabled !!!
		/*
		var old_style = document.getElementsByClassName('codemain');
		for(var j = 0; j < old_style.length; j++) {
			var curr = old_style[j];
			
			if(curr.firstChild.tagName && curr.firstChild.tagName.toLowerCase() == 'pre') continue;
			if(curr.firstChild.nodeName == '#comment') {
				curr.removeChild(curr.firstChild);
				curr.removeChild(curr.lastChild);
			}
			
			/ *
			curr.removeChild(curr.firstChild);
			curr.removeChild(curr.lastChild);
			* /
			
			highlightBlock(curr);
		}
		*/
		// end disabling
		/*
		-- volvo addition
		*/
	}
	
	function injectScripts(languages) {
		var scripts = document.getElementsByTagName('SCRIPT');
		for (var i = 0; i < scripts.length; i++) {
			if (scripts[i].src.match(/highlight\.js(\?.+)?$/)) {
				var path = scripts[i].src.replace(/highlight\.js(\?.+)?$/, '');
				break;
			}
		}
		if (languages.length == 0) {
			languages = DEFAULT_LANGUAGES;
		}
		
		var injected = {};
		for (var j = 0; j < languages.length; j++) {
			var filename = LANGUAGE_GROUPS[languages[j]] ? LANGUAGE_GROUPS[languages[j]] : languages[j];
			if (!injected[filename]) {
				document.write('<script type="text/javascript" src="' + path + 'languages/' + filename + '.js"></script>');
				injected[filename] = true;
			}
		}
	}
	
	function initHighlightingOnLoad() {
		var original_arguments = arguments;
		// injectScripts(arguments);
		initHighlighting.apply(null, original_arguments);
	}
	
	this.LANGUAGES = LANGUAGES;
	this.ALL_LANGUAGES = ALL_LANGUAGES;
	this.initHighlightingOnLoad = initHighlightingOnLoad;
	this.highlightBlock = highlightBlock;
	
	// Common regexps
	this.IDENT_RE = '[a-zA-Z][a-zA-Z0-9_]*';
	this.UNDERSCORE_IDENT_RE = '[a-zA-Z_][a-zA-Z0-9_]*';
	this.NUMBER_RE = '\\b\\d+(\\.\\d+)?';
	this.C_NUMBER_RE = '\\b(0x[A-Fa-f0-9]+|\\d+(\\.\\d+)?)';
	this.PAS_NUMBER_RE = '(\\$([A-Fa-f0-9]+)\\b)|(\\b(\\d+(\\.\\d+)?))';
	this.ADA_NUMBER_RE = '([\\d]+#(([\\da-fA-F])+_?)+#)|([\\d]+(\\.[\\d]+))|(\\b((([\\d]+)_?)*)[\\d]\\b)';
	
	this.ASM_NUMBER_RE = '\\b(\\d+[A-Ha-h]+|\\d+?)';
	
	// Common modes
	this.APOS_STRING_MODE = {
		className: 'string',
		begin: '\'', end: '\'',
		illegal: '\\n',
		contains: ['escape'],
		relevance: 0
	};
	this.QUOTE_STRING_MODE = {
		className: 'string',
		begin: '"', end: '"',
		illegal: '\\n',
		contains: ['escape'],
		relevance: 0
	};
	this.BACKSLASH_ESCAPE = {
		className: 'escape',
		begin: '\\\\.', end: '^',
		relevance: 0
	};
	this.C_LINE_COMMENT_MODE = {
		className: 'comment',
		begin: '//', end: '$',
		relevance: 0
	};
	this.C_BLOCK_COMMENT_MODE = {
		className: 'comment',
		begin: '/\\*', end: '\\*/'
	};
	this.HASH_COMMENT_MODE = {
		className: 'comment',
		begin: '#', end: '$'
	};
	
	this.PAS_NUMBER_MODE = {
		className: 'number',
		begin: this.PAS_NUMBER_RE, end: '^',
		relevance: 0
	};
	/*
	this.ADA_NUMBER_MODE = {
		className: 'number',
		begin: this.ADA_NUMBER_RE, end:'^',
		relevance:0
	};
	*/
	this.C_NUMBER_MODE = {
		className: 'number',
		begin: this.C_NUMBER_RE, end: '^',
		relevance: 0
	};
}();

// -- Added by Volvo 19/10/2008
hljs.ASM_KEYWORDS = {
};
// hljs.LANGUAGES.asm_done = {
 hljs.LANGUAGES.asm_1 = {
	defaultMode: {
		lexems: [hljs.IDENT_RE],
		illegal: '("|\\$[G-Zg-z]|\\/\\*|</)',
		contains: ['comment', 'string', 'number'],
		keywords: {
			'keyword': {
				'db':1, 'dw':1, 'dd':1
			},
			'built_in': {
				'ah':1, 'al':1, 'ax':1, 'bh':1, 'bl':1, 'bx':1, 'ch':1, 'cl':1, 'cx':1, 'dh':1, 'dl':1, 'dx':1,
				'eax':1, 'ebx':1, 'ecx':1, 'edx':1,
				'cr0':1, 'cr2':1, 'cr3':1, 'cr4':1, 'dr0':1, 'dr1':1, 'dr2':1, 'dr3':1, 'dr5':1, 'dr6':1, 'dr7':1,
				'mm0':1, 'mm1':1, 'mm2':1, 'mm3':1, 'mm4':1, 'mm5':1, 'mm6':1, 'mm7':1,
				'tr3':1, 'tr4':1, 'tr5':1, 'tr6':1, 'tr7':1, 
				'bp':1, 'ebp':1, 'cs':1, 'di':1, 'edi':1, 'ds':1, 'es':1, 'si':1, 'esi':1,
				'sp':1, 'esp':1, 'fs':1, 'gs':1, 'ss':1, 'st':1
			},
			'dot_words' : {
				'code':1, 'const':1, 'data':1, 'fardata':1, 'model':1, 'stack':1, 'startup':1, 'codeseg':1,
				'dataseg':1, 'end':1, 'ideal':1, 'masm':1, 'proc':1, 'endp':1, 'segment':1, 'ends':1, 
				'startupcode':1, 'udataseg':1, 'ufardata':1
			}
		}
	},
	case_insensitive: true,
	modes: [
		// comments from ";" to EOLn
		{
			className: 'comment',
			begin: ';', end: '$'
		},
		// comments between "(*" and "*)"
		{
			className: 'comment',
			begin: '\\(\\*', end: '\\*\\)',
			relevance: 10
		},
		// C-style comments 
		hljs.C_LINE_COMMENT_MODE,
		// numbers: ASM-style
		{
			className: 'number',
			//begin: hljs.NUMBER_RE, end: '^',
			begin: hljs.ASM_NUMBER_RE, end: '^',
			relevance: 0
		},
		// strings: between \" and \"
		{
			className: 'string',
			begin: '\'', end: '\'',
			contains: ['quote'],
			relevance: 0
		},
		// Pascal-style strings: "#"number
		{
			className: 'string',
			begin: '(#\\d+)+', end: '^'
		},
		{
			className: 'quote',
			begin: '\'\'', end: '^'
		},
		{
			className: 'function',
			begin: 'function', end: '[:;]',
			lexems: [hljs.IDENT_RE],
			keywords: {'function': 1},
			contains: ['title', 'params', 'comment'],
			relevance: 0
		},
		{
			className: 'function',
			begin: '(procedure|constructor|destructor)', end: ';',
			lexems: [hljs.IDENT_RE],
			keywords: {'constructor': 1, 'destructor': 1, 'procedure': 1},
			contains: ['title', 'params', 'comment'],
			relevance: 10
		},
		{
			className: 'title',
			begin: hljs.IDENT_RE, end: '^'
		},
		{
			className: 'params',
			begin: '\\(', end: '\\)',
			lexems: [hljs.IDENT_RE],
			keywords: hljs.DELPHI_KEYWORDS,
			contains: ['string']
		},
		{
			className: 'class',
			begin: '=\\s*class', end: 'end;',
			lexems: [hljs.IDENT_RE],
			keywords: hljs.DELPHI_CLASS_KEYWORDS,
			contains: ['string', 'comment', 'function']
		}
	]
};
// -- Added

// hljs.LANGUAGES.cpp_done = {
hljs.LANGUAGES.cpp_1 = {
	defaultMode: {
		lexems: [hljs.UNDERSCORE_IDENT_RE],
		illegal: '</',
		contains: ['comment', 'string', 'number', 'preprocessor'],
		keywords: {
			'keyword': {
				'false':1, 'int':1, 'float':1, 'while':1, 'private':1, 'char':1, 'catch':1, 'export':1,
				'virtual':1, 'operator':2, 'sizeof':2, 'dynamic_cast':2, 'typedef':2, 'const_cast':2, 'const':1,
				'struct':1, 'for':1, 'static_cast':2, 'union':1, 'namespace':1, 'unsigned':1, 'long':1, 'throw':1,
				'volatile':2, 'static':1, 'protected':1, 'bool':1, 'template':1, 'mutable':1, 'if':1, 'public':1,
				'friend':2, 'do':1, 'return':1, 'goto':1, 'auto':1, 'void':2, 'enum':1, 'else':1, 'break':1, 'new':1,
				'extern':1, 'using':1, 'true':1, 'class':1, 'asm':1, 'case':1, 'typeid':1, 'short':1, 'reinterpret_cast':2,
				'default':1, 'double':1, 'register':1, 'explicit':1, 'signed':1, 'typename':1, 'try':1, 'this':1, 'switch':1,
				'continue':1, 'wchar_t':1, 'inline':1, 'delete':1,
				'uint64_t':1, 'int64_t':1
			},
			'built_in': {
				'std':1, 'string':1, 'cin':1, 'cout':1, 'endl':1, 'cerr':1, 'clog':1, 'stringstream':1, 'istringstream':1,
				'ostringstream':1, 'auto_ptr':1, 'deque':1, 'list':1, 'queue':1, 'stack':1, 'vector':1, 'map':1,
				'set':1, 'bitset':1, 'multiset':1, 'multimap':1,
				'NULL':1, 'TRUE':1, 'FALSE':1
			}
		}
	},
	modes: [
		hljs.C_LINE_COMMENT_MODE,
		hljs.C_BLOCK_COMMENT_MODE,
		hljs.C_NUMBER_MODE,
		hljs.QUOTE_STRING_MODE,
		/*
		hljs.BACKSLASH_ESCAPE,
		{
			className: 'string',
			begin: '\'', end: '[^\\\\]\'',
			begin: '\'', end: '\'',
			illegal: '[^\\\\][^\']'
		},
		*/
		hljs.BACKSLASH_ESCAPE,
		{
			className: 'string',
			begin: '\'', end: '\'',
			contains: ['escape'],
			illegal: '[^\\\\][^\']'
		},
		{
			className: 'preprocessor',
			begin: '#', end: '$'
		}
	]
};

hljs.DELPHI_KEYWORDS = {
	'and':1, 'safecall':1, 'cdecl':1, 'then':1, 'string':1, 'exports':1, 'library':1, 'not':1, 'pascal':1,
	'set':1, 'virtual':1, 'file':1, 'in':1, 'array':1, 'label':1, 'packed':1, 'end.':1, 'index':1, 'while':1,
	'const':1, 'raise':1, 'for':1, 'to':1, 'implementation':1, 'with':1, 'except':1, 'overload':1, 'destructor':1,
	'downto':1, 'finally':1, 'program':1, 'exit':1, 'unit':1, 'inherited':1, 'override':1, 'if':1, 'type':1, 'until':1,
	'function':1, 'do':1, 'begin':1, 'repeat':1, 'goto':1, 'nil':1, 'far':1, 'initialization':1, 'object':1, 'else':1,
	'var':1, 'uses':1, 'external':1, 'resourcestring':1, 'interface':1, 'end':1, 'finalization':1, 'class':1, 'asm':1, 'assembler':1,
	'mod':1, 'case':1, 'on':1, 'shr':1, 'shl':1, 'of':1, 'register':1, 'xorwrite':1, 'threadvar':1, 'try':1, 'record':1,
	'near':1, 'stored':1, 'constructor':1, 'stdcall':1, 'inline':1, 'div':1, 'out':1, 'or':1, 'procedure':1
};
hljs.DELPHI_CLASS_KEYWORDS = {
	'safecall':1, 'stdcall':1, 'pascal':1, 'stored':1, 'const':1, 'implementation':1, 'finalization':1, 'except':1,
	'to':1, 'finally':1, 'program':1, 'inherited':1, 'override':1, 'then':1, 'exports':1, 'string':1, 'read':1, 'not':1,
	'mod':1, 'shr':1, 'try':1, 'div':1, 'shl':1, 'set':1, 'library':1, 'message':1, 'packed':1, 'index':1, 'for':1,
	'near':1, 'overload':1, 'label':1, 'downto':1, 'exit':1, 'public':1, 'goto':1, 'interface':1, 'asm':1, 'on':1,
	'of':1, 'constructor':1, 'or':1, 'private':1, 'array':1, 'unit':1, 'raise':1, 'destructor':1, 'var':1, 'type':1,
	'until':1, 'function':1, 'else':1, 'external':1, 'with':1, 'case':1, 'default':1, 'record':1, 'while':1, 'protected':1,
	'property':1, 'procedure':1, 'published':1, 'and':1, 'cdecl':1, 'do':1, 'threadvar':1, 'file':1, 'in':1, 'if':1, 'end':1,
	'virtual':1, 'write':1, 'far':1, 'out':1, 'begin':1, 'repeat':1, 'nil':1, 'initialization':1, 'object':1, 'uses':1,
	'resourcestring':1, 'class':1, 'register':1, 'xorwrite':1, 'inline':1
};


//hljs.LANGUAGES.pas_done = {
hljs.LANGUAGES.pas_1 = {
	defaultMode: {
		lexems: [hljs.IDENT_RE],
		illegal: '("|\\$[G-Zg-z]|\\/\\*|</)',
		contains: ['comment', 'string', 'number', 'function', 'class'],
		keywords: hljs.DELPHI_KEYWORDS
	},
	case_insensitive: true,
	modes: [
	
		hljs.PAS_NUMBER_MODE,
		
		
		{
			className: 'comment',
			begin: '{', end: '}'
		},
		{
			className: 'comment',
			begin: '\\(\\*', end: '\\*\\)',
			relevance: 10
		},
		hljs.C_LINE_COMMENT_MODE,
		
		{
			className: 'string',
			begin: '\'', end: '\'',
			contains: ['quote'],
			relevance: 0
		},
		{
			className: 'string',
			begin: '(#\\d+)+', end: '^'
		},
		{
			className: 'quote',
			begin: '\'\'', end: '^'
		},
		{
			className: 'function',
			begin: 'function', end: '[:;]',
			lexems: [hljs.IDENT_RE],
			keywords: {'function': 1},
			contains: ['title', 'params', 'comment'],
			relevance: 0
		},
		{
			className: 'function',
			begin: '(procedure|constructor|destructor)', end: ';',
			lexems: [hljs.IDENT_RE],
			keywords: {'constructor': 1, 'destructor': 1, 'procedure': 1},
			contains: ['title', 'params', 'comment'],
			relevance: 10
		},
		
		{
			className: 'title',
			begin: hljs.IDENT_RE, end: '^'
		},
		{
			className: 'params',
			begin: '\\(', end: '\\)',
			lexems: [hljs.IDENT_RE],
			keywords: hljs.DELPHI_KEYWORDS,
			contains: ['string']
		},
		{
			className: 'class',
			begin: '=\\s*class', end: 'end;',
			lexems: [hljs.IDENT_RE],
			keywords: hljs.DELPHI_CLASS_KEYWORDS,
			contains: ['string', 'comment', 'function']
		}
	]
};

hljs.SQL_KEYWORDS = {
	'all':1, 'partial':1, 'global':1, 'month':1, 'current_timestamp':1, 'using':1, 'go':1, 'revoke':1, 'smallint':1,
	'indicator':1, 'end-exec':1, 'disconnect':1, 'zone':1, 'with':1, 'character':1, 'assertion':1, 'to':1, 'add':1,
	'current_user':1, 'usage':1, 'input':1, 'local':1, 'alter':1, 'match':1, 'collate':1, 'real':1, 'then':1, 'rollback':1,
	'get':1, 'read':1, 'timestamp':1, 'session_user':1, 'not':1, 'integer':1, 'bit':1, 'unique':1, 'day':1, 'minute':1,
	'desc':1, 'insert':1, 'execute':1, 'like':1, 'level':1, 'decimal':1, 'drop':1, 'continue':1, 'isolation':1, 'found':1,
	'where':1, 'constraints':1, 'domain':1, 'right':1, 'national':1, 'some':1, 'module':1, 'transaction':1, 'relative':1,
	'second':1, 'connect':1, 'escape':1, 'close':1, 'system_user':1, 'for':1, 'deferred':1, 'section':1, 'cast':1,
	'current':1, 'sqlstate':1, 'allocate':1, 'intersect':1, 'deallocate':1, 'numeric':1, 'public':1, 'preserve':1, 'full':1,
	'goto':1, 'initially':1, 'asc':1, 'no':1, 'key':1, 'output':1, 'collation':1, 'group':1, 'by':1, 'union':1, 'session':1,
	'both':1, 'last':1, 'language':1, 'constraint':1, 'column':1, 'of':1, 'space':1, 'foreign':1, 'deferrable':1, 'prior':1,
	'connection':1, 'unknown':1, 'action':1, 'commit':1, 'view':1, 'or':1, 'first':1, 'into':1, 'float':1, 'year':1, 'primary':1,
	'cascaded':1, 'except':1, 'restrict':1, 'set':1, 'references':1, 'names':1, 'table':1, 'outer':1, 'open':1, 'select':1,
	'size':1, 'are':1, 'rows':1, 'from':1, 'prepare':1, 'distinct':1, 'leading':1, 'create':1, 'only':1, 'next':1, 'inner':1,
	'authorization':1, 'schema':1, 'corresponding':1, 'option':1, 'declare':1, 'precision':1, 'immediate':1, 'else':1,
	'timezone_minute':1, 'external':1, 'varying':1, 'translation':1, 'true':1, 'case':1, 'exception':1, 'join':1, 'hour':1,
	'default':1, 'double':1, 'scroll':1, 'value':1, 'cursor':1, 'descriptor':1, 'values':1, 'dec':1, 'fetch':1, 'procedure':1,
	'delete':1, 'and':1, 'false':1, 'int':1, 'is':1, 'describe':1, 'char':1, 'as':1, 'at':1, 'in':1, 'varchar':1, 'null':1, 'trailing':1,
	'any':1, 'absolute':1, 'current_time':1, 'end':1, 'grant':1, 'privileges':1, 'when':1, 'cross':1, 'check':1, 'write':1,
	'current_date':1, 'pad':1, 'begin':1, 'temporary':1, 'exec':1, 'time':1, 'update':1, 'catalog':1, 'user':1, 'sql':1,
	'date':1, 'on':1, 'identity':1, 'timezone_hour':1, 'natural':1, 'whenever':1, 'interval':1, 'work':1, 'order':1, 'cascade':1,
	'diagnostics':1, 'nchar':1, 'having':1, 'left':1
};

//hljs.LANGUAGES.sql_done = {
hljs.LANGUAGES.sql_1 = {
	case_insensitive: true,
	defaultMode: {
		lexems: [hljs.IDENT_RE],
		contains: ['string', 'number', 'comment'],
		keywords: {
			'keyword': hljs.SQL_KEYWORDS,
			'aggregate': {'count': 1, 'sum': 1, 'min': 1, 'max': 1, 'avg': 1}
		}
	},
	
	modes: [
		hljs.C_NUMBER_MODE,
		hljs.C_BLOCK_COMMENT_MODE,
		{
			className: 'comment',
			begin: '--', end: '$'
		},
		{
			className: 'string',
			begin: '\'', end: '\'',
			contains: ['escape', 'squote'],
			relevance: 0
		},
		{
			className: 'squote',
			begin: '\'\'', end: '^'
		},
		{
			className: 'string',
			begin: '"', end: '"',
			contains: [ 'escape', 'dquote'],
			relevance: 0
		},
		{
			className: 'dquote',
			begin: '""', end: '^'
		},
		{
			className: 'string',
			begin: '`', end: '`',
			contains: ['escape']
		},
		hljs.BACKSLASH_ESCAPE
	]
};

/*
Perl definition (c) Peter Leonov <gojpeg@yandex.ru>
*/
hljs.PERL_DEFAULT_CONTAINS = ['comment', 'string', 'number', 'regexp', 'sub', 'variable', 'operator', 'pod'];
hljs.PERL_KEYWORDS = {
	'getpwent':1, 'getservent':1, 'quotemeta':1, 'msgrcv':1, 'scalar':1, 'kill':1, 'dbmclose':1, 'undef':1,
	'lc':1, 'ma':1, 'syswrite':1, 'tr':1, 'send':1, 'umask':1, 'sysopen':1, 'shmwrite':1, 'vec':1, 'qx':1,
	'utime':1, 'local':1, 'oct':1, 'semctl':1, 'localtime':1, 'readpipe':1, 'do':1, 'return':1, 'format':1, 'read':1,
	'sprintf':1, 'dbmopen':1, 'pop':1, 'getpgrp':1, 'not':1, 'getpwnam':1, 'rewinddir':1, 'qq':1, 'fileno':1,
	'qw':1, 'endprotoent':1, 'wait':1, 'sethostent':1, 'bless':1, 's':1, 'opendir':1, 'continue':1, 'each':1,
	'sleep':1, 'endgrent':1, 'shutdown':1, 'dump':1, 'chomp':1, 'connect':1, 'getsockname':1, 'die':1,
	'socketpair':1, 'close':1, 'flock':1, 'exists':1, 'index':1, 'shmget':1, 'sub':1, 'for':1, 'endpwent':1,
	'redo':1, 'lstat':1, 'msgctl':1, 'setpgrp':1, 'abs':1, 'exit':1, 'select':1, 'print':1, 'ref':1, 'gethostbyaddr':1,
	'unshift':1, 'fcntl':1, 'syscall':1, 'goto':1, 'getnetbyaddr':1, 'join':1, 'gmtime':1, 'symlink':1, 'semget':1,
	'splice':1, 'x':1, 'getpeername':1, 'recv':1, 'log':1, 'setsockopt':1, 'cos':1, 'last':1, 'reverse':1,
	'gethostbyname':1, 'getgrnam':1, 'study':1, 'formline':1, 'endhostent':1, 'times':1, 'chop':1, 'length':1,
	'gethostent':1, 'getnetent':1, 'pack':1, 'getprotoent':1, 'getservbyname':1, 'rand':1, 'mkdir':1, 'pos':1,
	'chmod':1, 'y':1, 'substr':1, 'endnetent':1, 'printf':1, 'next':1, 'open':1, 'msgsnd':1, 'readdir':1, 'use':1,
	'unlink':1, 'getsockopt':1, 'getpriority':1, 'rindex':1, 'wantarray':1, 'hex':1, 'system':1, 'getservbyport':1,
	'endservent':1, 'int':1, 'chr':1, 'untie':1, 'rmdir':1, 'prototype':1, 'tell':1, 'listen':1, 'fork':1, 'shmread':1,
	'ucfirst':1, 'setprotoent':1, 'else':1, 'sysseek':1, 'link':1, 'getgrgid':1, 'shmctl':1, 'waitpid':1, 'unpack':1,
	'getnetbyname':1, 'reset':1, 'chdir':1, 'grep':1, 'split':1, 'require':1, 'caller':1, 'lcfirst':1, 'until':1, 'warn':1,
	'while':1, 'values':1, 'shift':1, 'telldir':1, 'getpwuid':1, 'my':1, 'getprotobynumber':1, 'delete':1, 'and':1,
	'sort':1, 'uc':1, 'defined':1, 'srand':1, 'accept':1, 'package':1, 'seekdir':1, 'getprotobyname':1, 'semop':1,
	'our':1, 'rename':1, 'seek':1, 'if':1, 'q':1, 'chroot':1, 'sysread':1, 'setpwent':1, 'no':1, 'crypt':1, 'getc':1,
	'chown':1, 'sqrt':1, 'write':1, 'setnetent':1, 'setpriority':1, 'foreach':1, 'tie':1, 'sin':1, 'msgget':1, 'map':1,
	'stat':1, 'getlogin':1, 'unless':1, 'elsif':1, 'truncate':1, 'exec':1, 'keys':1, 'glob':1, 'tied':1, 'closedir':1,
	'ioctl':1, 'socket':1, 'readlink':1, 'eval':1, 'xor':1, 'readline':1, 'binmode':1, 'setservent':1, 'eof':1, 'ord':1,
	'bind':1, 'alarm':1, 'pipe':1, 'atan2':1, 'getgrent':1, 'exp':1, 'time':1, 'push':1, 'setgrent':1, 'gt':1, 'lt':1,
	'or':1, 'ne':1, 'm':1
};

//hljs.LANGUAGES.perl_done = {
hljs.LANGUAGES.perl_1 = {
	defaultMode: {
		lexems: [hljs.IDENT_RE],
		contains: hljs.PERL_DEFAULT_CONTAINS,
		keywords: hljs.PERL_KEYWORDS
	},
	modes: [
		// variables
		{
			className: 'variable',
			begin: '\\$\\d', end: '^'
		},
		{
			className: 'variable',
			begin: '[\\$\\%\\@\\*](\\^\\w\\b|#\\w+(\\:\\:\\w+)*|[^\\s\\w{]|{\\w+}|\\w+(\\:\\:\\w*)*)', end: '^'
		},
		
		// numbers and strings
		{
			className: 'subst',
			begin: '[$@]\\{', end: '\}',
			lexems: [hljs.IDENT_RE],
			keywords: hljs.PERL_KEYWORDS,
			contains: hljs.PERL_DEFAULT_CONTAINS,
			relevance: 10
		},
		{
			className: 'number',
			begin: '(\\b0[0-7_]+)|(\\b0x[0-9a-fA-F_]+)|(\\b[1-9][0-9_]*(\\.[0-9_]+)?)|[0_]\\b', end: '^',
			relevance: 0
		},
		{
			className: 'string',
			begin: 'q[qwxr]?\\s*\\(', end: '\\)',
			contains: ['escape', 'subst', 'variable'],
			relevance: 5
		},
		{
			className: 'string',
			begin: 'q[qwxr]?\\s*\\[', end: '\\]',
			contains: ['escape', 'subst', 'variable'],
			relevance: 5
		},
		{
			className: 'string',
			begin: 'q[qwxr]?\\s*\\{', end: '\\}',
			contains: ['escape', 'subst', 'variable'],
			relevance: 5
		},
		{
			className: 'string',
			begin: 'q[qwxr]?\\s*\\|', end: '\\|',
			contains: ['escape', 'subst', 'variable'],
			relevance: 5
		},
		{
			className: 'string',
			begin: 'q[qwxr]?\\s*\\<', end: '\\>',
			contains: ['escape', 'subst', 'variable'],
			relevance: 5
		},
		{
			className: 'string',
			begin: 'qw\\s+q', end: 'q',
			contains: ['escape', 'subst', 'variable'],
			relevance: 5
		},
		{
			className: 'string',
			begin: '\'', end: '\'',
			contains: ['escape'],
			relevance: 0
		},
		{
			className: 'string',
			begin: '"', end: '"',
			contains: ['escape','subst','variable'],
			relevance: 0
		},
		hljs.BACKSLASH_ESCAPE,
		{
			className: 'string',
			begin: '`', end: '`',
			contains: ['escape']
		},
		
		// regexps
		{
			className: 'regexp',
			begin: '(s|tr|y)/(\\\\.|[^/])*/(\\\\.|[^/])*/[a-z]*', end: '^',
			relevance: 10
		},
		{
			className: 'regexp',
			begin: '(m|qr)?/', end: '/[a-z]*',
			contains: ['escape'],
			relevance: 0 // allows empty "//" which is a common comment delimiter in other languages
		},
		
		// bareword context
		{
			className: 'string',
			begin: '{\\w+}', end: '^',
			relevance: 0
		},
		{
			className: 'string',
			begin: '\-?\\w+\\s*\\=\\>', end: '^',
			relevance: 0
		},
		
		// subroutines
		{
			className: 'sub',
			begin: '\\bsub\\b', end: '(\\s*\\(.*?\\))?[;{]',
			lexems: [hljs.IDENT_RE],
			keywords: {'sub':1},
			relevance: 5
		},
		
		// operators
		{
			className: 'operator',
			begin: '-\\w\\b', end: '^',
			relevance: 0
		},
		
		// comments
		hljs.HASH_COMMENT_MODE,
		{
			className: 'comment',
			begin: '^(__END__|__DATA__)', end: '\\n$',
			relevance: 5
		},
		
		// pod
		{
			className: 'pod',
			begin: '\\=\\w', end: '\\=cut'
		}
	]
};

var initHighlightingOnLoad = hljs.initHighlightingOnLoad;

function addGlobalStyle(css) {
	var head, style;
	head = document.getElementsByTagName('head')[0];
	if (!head) {
		return;
	}
	style = document.createElement('style');
	style.type = 'text/css';
	style.innerHTML = css;
	head.appendChild(style);
	
	// added 31 jan 2009
	/*
	document.write('<script language="Javascript"><!--function selectAll(theField) {' +
		'var tempval=eval("document."+theField); tempval.focus(); tempval.select(); } //-->' +
		'</script>');
	*/
	/*
	var sel_scr = document.createElement('script');
	sel_scr.type = 'text/javascript';
	sel_scr.text = 'function selectAll(theField) {' +
		'var tempval=theField; tempval.focus(); tempval.select(); }';
	head.appendChild(sel_scr);
	*/
	// -- added 31 jan 2009
	
}

window.addEventListener("load",
	function(event) {
		addGlobalStyle(
		
		'pre code[class]:after {' + 
		'content: \'highlight: \' attr(class);' + 
		'display: block; text-align: right;' + 
		'font-size: smaller;' + 
		'color: #CCC; background: white;' +
		'border-top: solid 1px;' + 
		'padding-top: 0.5em;' + 
		'}' +
		'pre code {' +
		'display: block;' + 
		'background: #F0F0F0;' + 
		'}' + 
		'pre code, ' + 
		'.ruby .subst,' + 
		'.xml .title {' + 
		'  color: black;' + 
		'}' + 
		'.string {' +
		'  color: #4169E1;' +
		'}' +
		//'.string,' + 		
		'.title, ' + 
		'.parent,' + 
		'.tag .attribute .value,' + 
		'.rules .value,' + 
		'.rules .value .number,' + 
		//'.preprocessor,' + 
		'.ruby .symbol,' + 
		'.instancevar,' + 
		'.aggregate,' + 
		'.template_tag,' + 
		'.django .variable,' + 
		'.smalltalk .class,' + 
		'.addition,' + 
		'.flow,' + 
		'.stream,' + 
		'.bash .variable {' + 
		'  color: #800;' + 
		'}' + 
		
		/*
		// Ada
		'.attrs {' +
		'  color: #778899;' +
		'}' +
		*/
		
		// C/C++
		'.preprocessor {' + 
		'  color: #008080;' +
		'}' +
		'.comment {' +
		'  color: #000080;' +
		'  font-style: italic;' +
		'}' +
		
		// ASM
		'.dot_words {' + 
		'  color: #0000C0;' + 
		'  font-weight: bold;' +
		'}' + 
		'.built_in {' + 
		'  color: #778899;' + 
		'  font-style: italic;' +
		'}' + 
		
		//'.comment,' + 
		'.annotation,' +
		'.template_comment,' + 
		'.diff .header,' + 
		'.chunk {' + 
		// '  color: #888;' + 
		'  color: #000080;' + 
		'  font-style: italic;' + 
		'}' + 
		
		'.number {' +
		'  color: #4169E1;' +
		'}' +
		
		//'.number,' + 
		'.regexp,' + 
		'.literal,' + 
		'.smalltalk .symbol,' + 
		'.smalltalk .char,' + 
		'.change {' + 
		'  color: #080;' + 
		'}' +
		'.javadoc,' + 
		'.ruby .string,' + 
		'.decorator,' + 
		'.filter .argument,' + 
		'.localvars,' + 
		'.array,' + 
		'.attr_selector,' + 
		'.pi,' + 
		'.doctype,' + 
		'.deletion,' + 
		'.envvar,' + 
		'.shebang {' + 
		'  color: #88F;' + 
		'}' + 
		'.keyword,' + 
		'.id,' + 
		'.phpdoc,' + 
		'.title,' + 
		'.vbscript .built_in,' + 
		'.rsl .built_in,' +
		'.aggregate,' +
		'.smalltalk .class,' + 
		'.winutils,' + 
		'.bash .variable {' +
		'  font-weight: bold;' +
		'}' +
		'.html .css,' +
		'.html .javascript {' +
		'  opacity: 0.5;' +
		'}'		
		);
		// initHighlightingOnLoad('pas_done', 'cpp_done', 'asm_done', 'sql_done', 'perl_done');
		initHighlightingOnLoad('pas_1', 'cpp_1', 'asm_1', 'sql_1', 'perl_1');
	},
	true);
